/*
 * Decompiled with CFR 0.152.
 */
package bomba;

import bomba.AnimatedElements;
import bomba.Bomba;
import bomba.Config;
import bomba.GameDisplayable;
import bomba.LevelElements;
import bomba.Player;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameScrollField {
    private static final int OVERSCAN = 1;
    private static final int X_ELEMENTS = 9;
    private static final int Y_ELEMENTS = 9;
    public char[][][] actualLevel;
    public Image image;
    public Graphics gImage;
    private int xPos;
    private int yPos;
    private int levelX;
    private int levelY;
    private int numBombs;
    private int numExplosions;
    private int numDissolves;
    private boolean changed;
    private final GameDisplayable game;

    public GameScrollField(GameDisplayable gd) throws IllegalStateException, IllegalArgumentException {
        this.game = gd;
        int width = 144;
        int height = 144;
        this.image = Image.createImage((int)width, (int)height);
        this.gImage = this.image.getGraphics();
    }

    public void reset(int le) {
        char[][] tmpLevel = Bomba.level.getLevel(le);
        this.actualLevel = new char[2][Bomba.level.getHeight()][Bomba.level.getWidth()];
        this.actualLevel[0] = tmpLevel;
        Bomba.level.setLevel(le - 1);
        this.numBombs = Bomba.level.getNumBombs();
        this.numExplosions = 0;
        this.numDissolves = 0;
        Config.gc();
        this.paint();
    }

    public char getId(int x, int y) {
        try {
            char c = this.actualLevel[0][y][x];
            return c;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            char c = ' ';
            return c;
        }
    }

    private boolean setId(int x, int y, char id) {
        try {
            this.actualLevel[0][y][x] = id;
            boolean bl = true;
            return bl;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            boolean bl = false;
            return bl;
        }
    }

    private int getCount(int x, int y) {
        try {
            char c = this.actualLevel[1][y][x];
            return c;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            int n = 0;
            return n;
        }
    }

    private boolean setCount(int x, int y, int count) {
        try {
            this.actualLevel[1][y][x] = (char)count;
            boolean bl = true;
            return bl;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            boolean bl = false;
            return bl;
        }
    }

    public int getNumBombs() {
        return this.numBombs;
    }

    public int getNumExplosions() {
        return this.numExplosions;
    }

    public boolean scrollH(int step) {
        if (step == 0) {
            return false;
        }
        this.changed = true;
        this.xPos -= step;
        if (step < 0 ? this.xPos <= 24 : this.xPos + this.image.getWidth() >= 152) {
            return true;
        }
        int dx = step / Math.abs(step);
        this.levelX += dx;
        this.paintColumn(dx);
        this.xPos += dx * 16;
        return true;
    }

    public boolean scrollV(int step) {
        if (step == 0) {
            return false;
        }
        this.changed = true;
        this.yPos -= step;
        if (step < 0 ? this.yPos <= 70 : this.yPos + this.image.getHeight() >= 198) {
            return true;
        }
        int dy = step / Math.abs(step);
        this.levelY += dy;
        this.paintRow(dy);
        this.yPos += dy * 16;
        return true;
    }

    private void paintColumn(int dir) {
        int factor = (dir + 1) / 2;
        int offset = factor * 16;
        Image i = null;
        i = dir < 0 ? Image.createImage((Image)this.image) : this.image;
        this.gImage.drawImage(i, dir * -16, 0, 20);
        int xp = 8 * offset;
        int yp = 0;
        int x = this.levelX + 8 * factor;
        for (int y = this.levelY; y < this.levelY + 9; ++y) {
            Bomba.level.paintElement(this.gImage, this.getId(x, y), xp, yp, this.getCount(x, y));
            yp += 16;
        }
        this.changed = true;
    }

    private void paintRow(int dir) {
        int factor = (dir + 1) / 2;
        int offset = factor * 16;
        Image i = null;
        i = dir < 0 ? Image.createImage((Image)this.image) : this.image;
        this.gImage.drawImage(i, 0, dir * -16, 20);
        int xp = 0;
        int yp = 8 * offset;
        int y = this.levelY + 8 * factor;
        for (int x = this.levelX; x < this.levelX + 9; ++x) {
            Bomba.level.paintElement(this.gImage, this.getId(x, y), xp, yp, this.getCount(x, y));
            xp += 16;
        }
        this.changed = true;
    }

    public void paint(Graphics g) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        g.setClip(24, 70, 128, 128);
        g.drawImage(this.image, this.xPos, this.yPos, 20);
        g.setClip(clipX, clipY, clipW, clipH);
        this.changed = false;
    }

    public void paint() {
        int y = 0;
        for (int j = this.levelY; j < this.levelY + 9; ++j) {
            int x = 0;
            for (int i = this.levelX; i < this.levelX + 9; ++i) {
                Bomba.level.paintElement(this.gImage, this.getId(i, j), x, y, this.getCount(i, j));
                x += 16;
            }
            y += 16;
        }
        this.changed = true;
    }

    public void update(Graphics g) {
        this.updateExplosions();
        this.updateDissolves();
        this.updateView();
        Bomba.animated.nextPhase();
        this.paint(g);
    }

    private void updateView() {
        int y = 0;
        for (int j = this.levelY; j < this.levelY + 9; ++j) {
            int x = 0;
            for (int i = this.levelX; i < this.levelX + 9; ++i) {
                char id = this.getId(i, j);
                switch (id) {
                    case 'd': 
                    case 'l': 
                    case 'r': 
                    case 'u': {
                        if (AnimatedElements.delayRoll != 0) break;
                        Bomba.animated.paintRoll(this.gImage, id, x, y);
                        this.changed = true;
                        break;
                    }
                    case 't': {
                        if (AnimatedElements.delayTeleporter != 0) break;
                        Bomba.animated.paintTeleporter(this.gImage, x, y);
                        this.changed = true;
                    }
                }
                x += 16;
            }
            y += 16;
        }
    }

    private void updateExplosions() {
        if (this.numExplosions == 0 || AnimatedElements.delayExplosion != 0) {
            return;
        }
        int height = Bomba.level.getHeight();
        int width = Bomba.level.getWidth();
        for (int y = 0; y < height; ++y) {
            block4: for (int x = 0; x < width; ++x) {
                char id = this.getId(x, y);
                switch (id) {
                    case '!': 
                    case '#': 
                    case '*': {
                        int count = this.getCount(x, y);
                        if (count != 1) continue block4;
                        this.checkExplosion(x, y, id);
                        this.changed = true;
                    }
                }
            }
        }
        this.animateExplosions();
    }

    private void animateExplosions() {
        if (this.numExplosions == 0 || AnimatedElements.delayExplosion != 0) {
            return;
        }
        int height = Bomba.level.getHeight();
        int width = Bomba.level.getWidth();
        for (int y = 0; y < height; ++y) {
            block4: for (int x = 0; x < width; ++x) {
                char id = this.getId(x, y);
                switch (id) {
                    case '!': 
                    case '#': 
                    case '*': 
                    case '+': {
                        int count = this.getCount(x, y);
                        if (count == 8) {
                            this.changeTile(x, y, ' ');
                            --this.numExplosions;
                            if (id != '+') {
                                --this.numBombs;
                            }
                            this.checkNextLevel();
                            continue block4;
                        }
                        if (x >= this.levelX && x < this.levelX + 9 && y >= this.levelY && y < this.levelY + 9) {
                            int xp = (x - this.levelX) * 16;
                            int yp = (y - this.levelY) * 16;
                            Bomba.animated.paintExplosion(this.gImage, xp, yp, count);
                            this.changed = true;
                        }
                        this.setCount(x, y, ++count);
                    }
                }
            }
        }
    }

    private void updateDissolves() {
        if (this.numDissolves == 0 || AnimatedElements.delayDissolve != 0) {
            return;
        }
        int height = Bomba.level.getHeight();
        int width = Bomba.level.getWidth();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                char id = this.getId(x, y);
                if (id != '-') continue;
                int count = this.getCount(x, y);
                if (count == 4) {
                    this.changeTile(x, y, ' ');
                    --this.numDissolves;
                    continue;
                }
                if (x >= this.levelX && x < this.levelX + 9 && y >= this.levelY && y < this.levelY + 9) {
                    int xp = (x - this.levelX) * 16;
                    int yp = (y - this.levelY) * 16;
                    Bomba.animated.paintDissolve(this.gImage, xp, yp, count);
                    this.changed = true;
                }
                this.setCount(x, y, ++count);
            }
        }
    }

    public void changeTile(int x, int y, char id) {
        if (id != this.getId(x, y)) {
            this.setId(x, y, id);
            this.setCount(x, y, 0);
            switch (id) {
                case '!': 
                case '#': 
                case '*': 
                case '+': {
                    ++this.numExplosions;
                    break;
                }
                case '-': {
                    ++this.numDissolves;
                    break;
                }
                default: {
                    x = (x - this.levelX) * 16;
                    y = (y - this.levelY) * 16;
                    if (x < 0 || x >= this.image.getWidth() || y < 0 || y >= this.image.getHeight()) break;
                    LevelElements.paint(this.gImage, ' ', x, y);
                    this.changed = true;
                }
            }
        }
    }

    public void setPlayerPos(int x, int y, Player player) {
        int xView = 8;
        int yView = 8;
        int xLevel = Bomba.level.getWidth();
        int yLevel = Bomba.level.getHeight();
        this.xPos = 24;
        this.yPos = 70;
        if (xLevel < xView) {
            this.levelX = (xLevel - xView) / 2;
            this.xPos += (xView - xLevel & 1) * 16 / 2;
        } else {
            this.levelX = x - 3;
            this.levelX = Math.min(this.levelX, xLevel - xView);
            this.levelX = Math.max(this.levelX, 0);
        }
        if (yLevel < yView) {
            this.levelY = (yLevel - yView) / 2;
            this.yPos += (yView - yLevel & 1) * 16 / 2;
        } else {
            this.levelY = y - 3;
            this.levelY = Math.min(this.levelY, yLevel - yView);
            this.levelY = Math.max(this.levelY, 0);
        }
        int playerX = this.xPos + (x - this.levelX) * 16;
        int playerY = this.yPos + (y - this.levelY) * 16;
        player.setPos(playerX, playerY);
    }

    private void checkExplosion(int x, int y, char id) {
        int r = -1;
        switch (id) {
            case '*': {
                r = 1;
                break;
            }
            case '!': {
                r = 2;
                break;
            }
            case '#': {
                r = 3;
            }
        }
        int r2 = -1;
        for (int i = -r; i <= r; ++i) {
            r2 = i <= 0 ? ++r2 : --r2;
            block17: for (int j = -r2; j <= r2; ++j) {
                int x2 = x + j;
                int y2 = y + i;
                char id2 = this.getId(x2, y2);
                if (i == -r || i == r || j == -r2 || j == r2) {
                    switch (id2) {
                        case 'A': 
                        case 'm': {
                            id2 = '*';
                            break;
                        }
                        case 'B': {
                            id2 = '!';
                            break;
                        }
                        case 'C': {
                            id2 = '#';
                            break;
                        }
                        default: {
                            continue block17;
                        }
                    }
                    Config.playExploSound();
                    this.changeTile(x2, y2, id2);
                    continue;
                }
                switch (id2) {
                    case 'A': 
                    case 'm': {
                        id2 = '*';
                        Config.playExploSound();
                        break;
                    }
                    case 'B': {
                        id2 = '!';
                        Config.playExploSound();
                        break;
                    }
                    case 'C': {
                        id2 = '#';
                        Config.playExploSound();
                        break;
                    }
                    case ' ': 
                    case '!': 
                    case '#': 
                    case '*': 
                    case '+': 
                    case '-': 
                    case 'f': {
                        continue block17;
                    }
                    default: {
                        id2 = '+';
                    }
                }
                this.changeTile(x2, y2, id2);
            }
        }
    }

    public void explodeBomb(int x, int y) {
        char id = this.getId(x, y);
        switch (id) {
            case 'A': 
            case 'm': {
                id = '*';
                break;
            }
            case 'B': {
                id = '!';
                break;
            }
            case 'C': {
                id = '#';
                break;
            }
            default: {
                return;
            }
        }
        Config.playExploSound();
        this.changeTile(x, y, id);
    }

    private void checkNextLevel() {
        if (this.numBombs <= 0 && this.numExplosions <= 0 && this.game.player.getAnimation() != 4) {
            this.game.startBlendNextLevel();
        }
    }

    static {
        OVERSCAN = 1;
        X_ELEMENTS = 9;
        Y_ELEMENTS = 9;
    }
}

