/*
 * Decompiled with CFR 0.152.
 */
package bomba;

import bomba.Bomba;
import bomba.GameDisplayable;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Player {
    public static Image anim;
    public static final char UP = '\u0000';
    public static final char RIGHT = '\u0001';
    public static final char DOWN = '\u0002';
    public static final char LEFT = '\u0003';
    public static final char FALL = '\u0004';
    public static final char WAIT = '\u0005';
    public static final char SLOAP = '\u0006';
    public static final char ROLL = '\u0007';
    private static final char DELAY_RUN = '\u0004';
    private static final char DELAY_FALL = '\u0006';
    private static final char DELAY_WAIT = '\u0004';
    public boolean teleporting;
    public int levelX;
    public int levelY;
    private final GameDisplayable game;
    private int xPos;
    private int yPos;
    private final int anims;
    private final int frames;
    private int animDelay;
    private int animIndex;
    private int animFrame;
    private int state;

    public Player(GameDisplayable gd) throws IOException {
        this.game = gd;
        try {
            anim = Image.createImage((String)"/player.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.anims = anim.getHeight() / 16;
        this.frames = anim.getWidth() / 16;
        this.reset();
    }

    public void reset() {
        this.animDelay = 0;
        this.setLevelPos(Bomba.level.getStartX(), Bomba.level.getStartY());
        this.teleporting = false;
        this.setAnimation(5);
        this.setState(5);
    }

    public int getXPos() {
        return this.xPos;
    }

    public int getYPos() {
        return this.yPos;
    }

    public void setPos(int x, int y) {
        this.xPos = x;
        this.yPos = y;
    }

    public void moveX(int dx) {
        this.xPos += dx;
    }

    public void moveY(int dy) {
        this.yPos += dy;
    }

    public void setLevelPos(int x, int y) {
        this.levelX = x;
        this.levelY = y;
    }

    public void moveLevelPos(int dx, int dy) {
        if (dx != 0 || dy != 0) {
            this.levelX += dx;
            this.levelY += dy;
            this.teleporting = false;
        }
    }

    public int getAnimation() {
        return this.animIndex;
    }

    public void setAnimation(int ani) {
        if (ani != this.animIndex && ani >= 0 && ani < this.anims) {
            this.animIndex = ani;
            this.setDelay();
        }
    }

    public void invertAnimation() {
        switch (this.animIndex) {
            case 0: {
                this.animIndex = 2;
                break;
            }
            case 2: {
                this.animIndex = 0;
                break;
            }
            case 3: {
                this.animIndex = 1;
                break;
            }
            case 1: {
                this.animIndex = 3;
            }
        }
    }

    public int getState() {
        return this.state;
    }

    public void setState(int s) {
        if (s == 6 || s == 7 || s == 5) {
            this.state = s;
        }
    }

    private void setDelay() {
        switch (this.animIndex) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.animDelay = 4;
                break;
            }
            case 4: {
                this.animDelay = 6;
                break;
            }
            case 5: {
                this.animDelay = 4;
            }
        }
    }

    public void paint(Graphics g) {
        this.paint(g, this.xPos, this.yPos, this.animFrame, this.animIndex);
        if (this.state != 7 && this.state != 6 && --this.animDelay < 0) {
            this.setDelay();
            if (++this.animFrame >= this.frames) {
                this.animFrame = 0;
                if (this.animIndex == 4) {
                    this.game.startBlendLostLive();
                }
            }
        }
    }

    public void paint(Graphics g, int x, int y, int ix, int iy) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        g.clipRect(x, y, 16, 16);
        g.drawImage(anim, x -= ix * 16, y -= iy * 16, 20);
        g.setClip(clipX, clipY, clipW, clipH);
    }

    static {
        UP = '\u0000';
        RIGHT = '\u0001';
        DOWN = (char)2;
        LEFT = (char)3;
        FALL = (char)4;
        WAIT = (char)5;
        SLOAP = (char)6;
        ROLL = (char)7;
        DELAY_RUN = (char)4;
        DELAY_FALL = (char)6;
        DELAY_WAIT = (char)4;
    }
}

