/*
 * Decompiled with CFR 0.152.
 */
package de.tuttas.GameAPI;

import de.tuttas.GameAPI.MenuItem;
import de.tuttas.GameAPI.MenuListener;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Menu {
    private Vector items = new Vector();
    private MenuItem selectedItem;
    private int index;
    private int yOffset;
    private MenuListener listener;
    private boolean visible = false;
    public int MenuStart;
    public static Image left = null;
    public static Image right = null;

    public Menu(int offsetY, int start) {
        this.yOffset = offsetY;
        this.MenuStart = start;
    }

    public Menu(int yPos) {
        this.MenuStart = yPos;
        this.yOffset = -1;
        if (left == null) {
            try {
                left = Image.createImage((String)"/de/tuttas/GameAPI/left.png");
                right = Image.createImage((String)"/de/tuttas/GameAPI/right.png");
            }
            catch (IOException iox) {
                iox.printStackTrace();
            }
        }
    }

    public void setListener(MenuListener ml) {
        this.listener = ml;
    }

    public void add(MenuItem mi) {
        if (this.items.size() == 0) {
            this.selectedItem = mi;
            mi.setSelect(true);
        }
        this.items.addElement(mi);
    }

    public void select() {
        this.listener.select(this.selectedItem);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean state) {
        this.visible = state;
    }

    public void up() {
        try {
            this.selectedItem.setSelect(false);
            this.selectedItem = (MenuItem)this.items.elementAt(this.index - 1);
            --this.index;
            this.selectedItem.setSelect(true);
        }
        catch (ArrayIndexOutOfBoundsException aob) {
            this.selectedItem.setSelect(true);
        }
    }

    public void down() {
        try {
            this.selectedItem.setSelect(false);
            this.selectedItem = (MenuItem)this.items.elementAt(this.index + 1);
            ++this.index;
            this.selectedItem.setSelect(true);
        }
        catch (ArrayIndexOutOfBoundsException aob) {
            this.selectedItem.setSelect(true);
        }
    }

    public void left() {
        this.up();
    }

    public void right() {
        this.down();
    }

    public MenuItem getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(MenuItem mi) {
        this.selectedItem = mi;
        mi.isSelected = true;
        this.index = this.items.indexOf(mi);
    }

    public void paint(Graphics g, int x) {
        int y = this.MenuStart;
        if (this.yOffset != -1) {
            for (int i = 0; i < this.items.size(); ++i) {
                MenuItem tmpItem = (MenuItem)this.items.elementAt(i);
                tmpItem.paint(g, x, y);
                y += this.yOffset;
            }
        } else {
            int width = MenuItem.width;
            if (this.selectedItem != (MenuItem)this.items.firstElement()) {
                g.drawImage(left, x - MenuItem.width / 2 - 2, y + g.getFont().getHeight() / 2, 10);
            }
            if (this.selectedItem != (MenuItem)this.items.lastElement()) {
                g.drawImage(right, x + MenuItem.width / 2 + 2, y + g.getFont().getHeight() / 2, 6);
            }
            this.selectedItem.paint(g, x, y);
        }
    }

    public void paint(Graphics g) {
        this.paint(g, g.getClipWidth() / 2);
    }
}

