/*
 * Decompiled with CFR 0.152.
 */
package rivergon.connect4;

import com.mforma.Mforma;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.midlet.MIDlet;
import rivergon.connect4.Connect4Game;
import rivergon.connect4.Connect4MIDlet;
import rivergon.connect4.GameTask;
import rivergon.connect4.GlobalDefs;
import rivergon.connect4.Player;
import rivergon.j2me.CustomFont;
import rivergon.j2me.Dialog;
import rivergon.j2me.MIDletConfig;
import rivergon.j2me.Menu;
import rivergon.j2me.MenuItem;

public final class Connect4Canvas
extends Canvas {
    public static int LEFT_SOFT_KEY = -6;
    public static int RIGHT_SOFT_KEY = -7;
    public static final int ALT_LEFT_SOFT_KEY = 21;
    public static final int ALT_RIGHT_SOFT_KEY = 22;
    private static final byte SCR_ID_SPLASH_1 = 1;
    private static final byte SCR_ID_SPLASH_2 = 2;
    private static final byte SCR_ID_SPLASH_3 = 3;
    private static final byte SCR_ID_SPLASH_4 = 4;
    private static final byte SCR_ID_MAIN = 5;
    private static final byte SCR_ID_SOLO_PLAY = 6;
    private static final byte SCR_ID_PASS_PLAY = 7;
    private static final byte SCR_ID_OPTIONS = 8;
    private static final byte SCR_ID_HELP = 9;
    private static final byte SCR_ID_QUIT_GAME = 10;
    private static final byte SCR_ID_RESUME = 11;
    private static final byte SCR_ID_GAME = 12;
    private static final byte SCR_ID_HALL_OF_FAME = 13;
    private static final byte SCR_ID_GAME_OVER_1 = 14;
    private static final byte SCR_ID_GAME_OVER_2 = 15;
    private static final byte SCR_ID_GAME_OVER_3 = 16;
    public static MIDletConfig midletConfig;
    boolean inGame;
    private boolean paused;
    private boolean destroy;
    private Connect4MIDlet midlet;
    private int canvasW;
    private int canvasH;
    private int handPos;
    private Connect4Game game;
    private CustomFont customFontDlg;
    private String dlgInfoText;
    private int screenId;
    private Menu screenMenu;
    private String screenName;
    private int screenMenuXPos;
    private int screenMenuYPos;
    private CustomFont mainFont;
    private CustomFont menuOffFont;
    private CustomFont menuOnFont;
    private int helpLine;
    private Image imgScrBackground;
    private Image imgScrName;
    private Image imgScrIcon;
    private Image imgSplashTitle1;
    private int splashTitle1FrameId;
    private Image imgGameBoard;
    private Image imgIllegalMove;
    private int pointerFrameId;
    private boolean flashIllegalMove;
    private Image imgFour;
    private Image imgExplosions;
    private int explosionsFrameId;
    private Image imgWinnerText;
    private Image imgWinnerBigPiece;
    private int fourFrameId;
    private int winnerTextFrameId;
    private Timer gameTimer;
    private GameTask gameTask;
    private int seqCounter;
    private boolean gameOver;
    private Player winner;
    private String soundBeforeSuspend;
    private String currentSound;
    private javax.microedition.media.Player soundPlayer;
    private boolean is3660 = false;

    Connect4Canvas(Connect4MIDlet connect4MIDlet) {
        this.setFullScreenMode(true);
        this.midlet = connect4MIDlet;
        this.screenId = 1;
        this.flashIllegalMove = false;
        this.dlgInfoText = null;
        this.paused = false;
        String string = System.getProperty("microedition.platform");
        if (string != null) {
            this.is3660 = string.indexOf("3620") > 0 || string.indexOf("3660") > 0;
        }
    }

    void doLoading() {
        try {
            this.canvasW = this.getWidth();
            this.canvasH = this.getHeight();
            if (this.canvasH <= 190) {
                this.canvasH = 204;
                LEFT_SOFT_KEY = -21;
                RIGHT_SOFT_KEY = -22;
            }
            midletConfig = new MIDletConfig("Connect4 SP");
            this.customFontDlg = new CustomFont(Font.getFont((int)32, (int)0, (int)8));
            this.mainFont = new CustomFont(Image.createImage((String)"/font_main.png"), ' ', 'z', GlobalDefs.fontCharWidths);
            this.menuOffFont = new CustomFont(Image.createImage((String)"/font_menuoff.png"), ' ', 'z', GlobalDefs.menuOffFontCharWidths);
            this.menuOnFont = new CustomFont(Image.createImage((String)"/font_menuon.png"), ' ', 'z', GlobalDefs.menuOnFontCharWidths);
            this.initScreen();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getGameAction(int n) {
        if (n == 53) {
            return 8;
        }
        try {
            return super.getGameAction(n);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        try {
            if (this.paused) {
                this.paused = false;
                if (this.screenId == 16) {
                    this.screenId = 5;
                    this.initScreen();
                } else {
                    this.playSound(this.soundBeforeSuspend, -1);
                    this.soundBeforeSuspend = null;
                }
                this.repaint();
                return;
            }
            this.flashIllegalMove = false;
            this.dlgInfoText = null;
            if (n == LEFT_SOFT_KEY || n == 21) {
                if (this.screenId == 6 || this.screenId == 8 || this.screenId == 9 || this.screenId == 10 || this.gameOver) {
                    if (this.inGame && this.screenId != 10) {
                        if (this.screenId == 8) {
                            this.screenId = 12;
                        } else if (this.screenId == 9) {
                            this.screenId = 8;
                        }
                    } else {
                        this.game = null;
                        this.screenId = 5;
                    }
                } else if (this.screenId == 12) {
                    this.inGame = true;
                    this.screenId = 8;
                }
                this.initScreen();
            } else if (this.screenId == 9) {
                if (n2 == 6) {
                    if (++this.helpLine >= GlobalDefs.helpNotice.length) {
                        --this.helpLine;
                    }
                } else if (n2 == 1 && --this.helpLine < 0) {
                    this.helpLine = 0;
                }
            } else if (this.screenId == 10) {
                if (n == RIGHT_SOFT_KEY || n == 22) {
                    this.screenId = 8;
                }
            } else if (this.screenMenu != null) {
                if (n == RIGHT_SOFT_KEY || n == 22) {
                    n2 = 5;
                }
                this.screenMenu.processAction(n2);
            } else if (this.screenId == 12) {
                if (this.game.getCurrentPlayer().type == Player.TYPE_NETWORK || this.game.getCurrentPlayer().type == Player.TYPE_MACHINE) {
                    this.dlgInfoText = "Please Wait!";
                    this.repaint();
                    return;
                }
                if (n2 == 8) {
                    if (this.game.applyMove(this.handPos) < 0) {
                        this.flashIllegalMove = true;
                    } else if (!this.gameOver) {
                        this.checkGameOver();
                        Player player = this.game.nextPlayer();
                        if (!this.gameOver && player.type == Player.TYPE_MACHINE) {
                            this.dlgInfoText = "Please Wait!";
                            player.calcMove();
                        }
                    }
                } else if (n2 == 5 || n2 == 2) {
                    int n3 = n2 == 5 ? 1 : -1;
                    this.handPos += n3;
                    if (this.handPos >= 7) {
                        this.handPos = 0;
                    }
                    if (this.handPos < 0) {
                        this.handPos = 6;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.repaint();
    }

    public void menuEvent(Menu menu, int n) {
        try {
            MenuItem menuItem = menu.getItem(menu.getCurrentItemIdx());
            String string = menuItem.getEntryName(menuItem.getCurrentEntryIdx());
            if (n == 8) {
                switch (this.screenId) {
                    case 5: {
                        if (string.equals("Solo Play")) {
                            this.screenId = 6;
                        } else if (string.equals("Pass Play")) {
                            this.game = Connect4Game.getInstance(this, "BLACK", Player.TYPE_HUMAN, -1, "RED", Player.TYPE_HUMAN, -1);
                            this.screenId = 12;
                        } else if (string.equals("Options")) {
                            this.screenId = 8;
                        } else if (string.equals("Help")) {
                            this.screenId = 9;
                        } else if (string.equals("Exit")) {
                            this.destroy = true;
                            this.stopSound();
                            Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)Mforma.outro(this.midlet.getAppProperty("Mforma-Outro-URL")));
                            new Timer().schedule((TimerTask)new GameTask(this), 2000L);
                        }
                        this.initScreen();
                        break;
                    }
                    case 6: {
                        if (string.equals("Play Black")) {
                            this.game = Connect4Game.getInstance(this, "BLACK", Player.TYPE_HUMAN, -1, "RED", Player.TYPE_MACHINE, midletConfig.getAILevel());
                            this.screenId = 12;
                            this.initScreen();
                            break;
                        }
                        if (!string.equals("Play Red")) break;
                        this.screenId = 12;
                        this.initScreen();
                        this.game = Connect4Game.getInstance(this, "BLACK", Player.TYPE_MACHINE, midletConfig.getAILevel(), "RED", Player.TYPE_HUMAN, -1);
                        Player player = this.game.getCurrentPlayer();
                        player.calcMove();
                        this.dlgInfoText = "Please Wait!";
                        break;
                    }
                    case 8: {
                        if (string.equals("Resume Game")) {
                            this.screenId = 12;
                            this.initScreen();
                            break;
                        }
                        if (string.equals("Help")) {
                            this.screenId = 9;
                            this.initScreen();
                            break;
                        }
                        if (!string.equals("Quit Game")) break;
                        this.screenId = 10;
                    }
                }
            } else if (n == 2 || n == 5) {
                switch (this.screenId) {
                    case 6: {
                        if (string.equals("Level: Casual")) {
                            midletConfig.setAILevel(0);
                            break;
                        }
                        if (string.equals("Level: Good")) {
                            midletConfig.setAILevel(1);
                            break;
                        }
                        if (!string.equals("Level: Expert")) break;
                        midletConfig.setAILevel(2);
                        break;
                    }
                    case 8: {
                        if (string.equals("Sound: Off")) {
                            midletConfig.setSound(false);
                            this.stopSound();
                            break;
                        }
                        if (!string.equals("Sound: On")) break;
                        midletConfig.setSound(true);
                        if (this.inGame) {
                            this.playSound("sfxgame.midi", -1);
                            break;
                        }
                        this.playSound("sfxgame.midi", -1);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void gameEvent(int n) {
        try {
            this.dlgInfoText = null;
            this.handPos = n;
            this.game.applyMove(this.handPos);
            this.checkGameOver();
            if (!this.gameOver) {
                this.game.nextPlayer();
            }
            this.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void tickEvent() {
        if (this.destroy) {
            this.midlet.destroyApp(this.destroy);
            this.midlet.notifyDestroyed();
        }
        ++this.pointerFrameId;
        if (this.pointerFrameId >= 5) {
            this.pointerFrameId = 0;
        }
        this.repaint();
    }

    public void pauseAppEvent(boolean bl) {
        if (bl) {
            this.paused = bl;
            this.soundBeforeSuspend = this.currentSound;
            this.stopSound();
        }
    }

    public void paint(Graphics graphics) {
        try {
            if (this.paused) {
                Dialog.showGeneral("Game Paused", 0xEFEFEF, this.customFontDlg, null, 170, (this.canvasW - 115) / 2, this.canvasH / 2 - 10, 115, 20, graphics, -1L);
                Dialog.showGeneral("Hit Any Key!", 0xEFEFEF, this.customFontDlg, null, 170, (this.canvasW - 115) / 2, this.canvasH / 2 + 10, 115, 20, graphics, -1L);
                return;
            }
            if (this.screenId == 12) {
                this.paintGameScreen(graphics);
            } else if (this.screenId >= 14 && this.screenId <= 16) {
                this.paintGameOverScreens(graphics);
            } else {
                if (this.screenId == 10) {
                    this.paintMenuScreen(graphics);
                    graphics.setClip(0, 0, this.canvasW, this.canvasH);
                    Dialog.showGeneral("Quit?", 0xEFEFEF, this.customFontDlg, null, 170, (this.canvasW - 115) / 2, this.canvasH / 2, 115, 20, graphics, -1L);
                    Dialog.showGeneral("YES", 0xEFEFEF, this.customFontDlg, null, 170, 3, this.canvasH - 22, 22, 20, graphics, -1L);
                    Dialog.showGeneral("NO", 0xEFEFEF, this.customFontDlg, null, 170, this.canvasW - 27, this.canvasH - 22, 22, 20, graphics, -1L);
                    return;
                }
                if (this.screenId > 4) {
                    this.paintMenuScreen(graphics);
                } else if (this.screenId == 1) {
                    graphics.setColor(0, 0, 0);
                    graphics.fillRect(0, 0, this.canvasW, this.canvasH);
                    graphics.drawImage(this.imgScrBackground, this.canvasW / 2, (this.canvasH - this.imgScrBackground.getHeight()) / 2, 17);
                    if (this.seqCounter++ > 6) {
                        this.screenId = 2;
                        this.initScreen();
                        return;
                    }
                } else if (this.screenId == 2) {
                    graphics.setColor(0, 0, 0);
                    graphics.fillRect(0, 0, this.canvasW, this.canvasH);
                    graphics.setColor(255, 255, 255);
                    Font font = Font.getFont((int)0, (int)0, (int)8);
                    for (int i = 0; i < GlobalDefs.splashNotice.length; ++i) {
                        graphics.drawString(GlobalDefs.splashNotice[i], this.canvasW >> 1, 60 + i * (font.getHeight() + 7), 17);
                    }
                    if (this.seqCounter++ > 6) {
                        this.screenId = 3;
                        this.initScreen();
                        return;
                    }
                } else if (this.screenId == 3) {
                    graphics.fillRect(0, 0, this.canvasW, this.canvasH);
                    graphics.drawImage(this.imgScrBackground, this.canvasW / 2, (this.canvasH - this.imgScrBackground.getHeight()) / 2, 17);
                    if (this.seqCounter++ > 5) {
                        this.screenId = 4;
                        this.initScreen();
                        return;
                    }
                } else if (this.screenId == 4) {
                    graphics.drawImage(this.imgScrBackground, this.canvasW / 2, (this.canvasH - this.imgScrBackground.getHeight()) / 2, 17);
                    if (this.seqCounter++ > 7) {
                        this.screenId = 5;
                        this.initScreen();
                        new Timer().schedule((TimerTask)new GameTask(this), 10L);
                        return;
                    }
                }
            }
            if (this.dlgInfoText != null) {
                Dialog.showGeneral(this.dlgInfoText, 0xEFEFEF, this.customFontDlg, null, 170, (this.canvasW - 115) / 2, this.canvasH / 2, 115, 20, graphics, -1L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void paintMenuScreen(Graphics graphics) {
        this.playSound("sfxgame.midi", -1);
        graphics.drawImage(this.imgScrBackground, this.canvasW / 2, (this.canvasH - this.imgScrBackground.getHeight()) / 2, 1 | 0x10);
        if (this.screenId == 6 || this.screenId == 8) {
            graphics.drawImage(this.imgScrName, this.screenMenuXPos, 53, 1 | 0x10);
            graphics.drawImage(this.imgScrIcon, this.canvasW - this.imgScrIcon.getWidth(), 53, 1 | 0x10);
        } else if (this.screenId == 9) {
            int n;
            for (int i = 0; i < GlobalDefs.helpNotice.length && (n = 50 + i * (this.mainFont.charHeight() + 1)) <= this.canvasH - this.mainFont.charHeight(); ++i) {
                this.mainFont.drawString(GlobalDefs.helpNotice[i + this.helpLine], 1, n, graphics);
            }
            return;
        }
        if (this.screenMenu != null) {
            this.screenMenu.paint(this.screenMenuXPos, this.screenMenuYPos, graphics, 1);
        }
    }

    private void paintGameScreen(Graphics graphics) {
        if (this.screenId < 14) {
            this.playSound("sfxgame.midi", -1);
        }
        int n = (this.canvasW - this.imgGameBoard.getWidth()) / 2;
        int n2 = this.canvasH - this.imgGameBoard.getHeight();
        graphics.drawImage(this.imgGameBoard, n, n2, 4 | 0x10);
        if (this.game == null) {
            return;
        }
        Player player = this.game.getCurrentPlayer();
        Player player2 = this.game.getNextPlayer(player.id);
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 6; ++j) {
                Image image = null;
                if (this.game.board[i][j] == player.id) {
                    image = player.imgPiece;
                } else if (this.game.board[i][j] == player2.id) {
                    image = player2.imgPiece;
                }
                if (image == null) continue;
                graphics.drawImage(image, n + 10 + i * 23, this.canvasH - 29 - j * 23, 4 | 0x10);
            }
        }
        if (this.flashIllegalMove) {
            graphics.drawImage(this.imgIllegalMove, this.canvasW / 2, this.canvasH / 2, 3);
        }
        Image image = player.imgTurnIndicator;
        graphics.drawImage(image, this.canvasW / 2, 1, 17);
        Image image2 = player.imgPointer;
        int n3 = graphics.getClipX();
        int n4 = graphics.getClipY();
        int n5 = graphics.getClipWidth();
        int n6 = graphics.getClipHeight();
        int n7 = n + 10 + this.handPos * 23;
        int n8 = n2 + 32;
        graphics.setClip(n7, n8, 19, 18);
        graphics.drawImage(image2, n7 - this.pointerFrameId * 19, n8, 20);
        if (this.gameOver && this.screenId == 15) {
            for (int i = 0; i < 4; ++i) {
                int n9 = n + 7 + this.game.c4x[i] * 23;
                int n10 = this.canvasH - 32 - this.game.c4y[i] * 23;
                graphics.setClip(n9, n10, 24, 24);
                graphics.drawImage(this.imgExplosions, n9 - this.explosionsFrameId * 24, n10, 20);
            }
            if (this.explosionsFrameId++ >= 10) {
                this.explosionsFrameId = 0;
            }
        }
        graphics.setClip(n3, n4, n5, n6);
    }

    private void paintGameOverScreens(Graphics graphics) {
        try {
            switch (this.screenId) {
                case 14: {
                    this.paintGameScreen(graphics);
                    int n = this.imgFour.getWidth() / 5;
                    int n2 = (this.canvasW - n) / 2;
                    int n3 = (this.canvasH - this.imgFour.getHeight()) / 2;
                    graphics.setClip(n2, n3, n, this.imgFour.getHeight());
                    graphics.drawImage(this.imgFour, n2 - this.fourFrameId * n, n3, 20);
                    if (this.fourFrameId++ >= 4) {
                        this.fourFrameId = 4;
                    }
                    if (this.seqCounter++ < 5) break;
                    this.screenId = 15;
                    this.initScreen();
                    break;
                }
                case 15: {
                    this.paintGameScreen(graphics);
                    if (this.seqCounter++ < 10) break;
                    this.screenId = 16;
                    this.initScreen();
                    break;
                }
                case 16: {
                    if (this.imgScrBackground != null) {
                        graphics.drawImage(this.imgScrBackground, this.canvasW / 2, (this.canvasH - this.imgScrBackground.getHeight()) / 2, 1 | 0x10);
                    }
                    if (this.imgWinnerText != null) {
                        int n = this.imgWinnerText.getWidth() / 3;
                        int n4 = (this.canvasW - n) / 2;
                        int n5 = 10 + (this.canvasH - this.imgWinnerText.getHeight()) / 2 - this.imgWinnerText.getHeight();
                        graphics.setClip(n4, n5, n, this.imgWinnerText.getHeight());
                        graphics.drawImage(this.imgWinnerText, n4 - this.winnerTextFrameId * n, n5, 20);
                        graphics.setClip(0, 0, this.canvasW, this.canvasH);
                        graphics.drawImage(this.imgWinnerBigPiece, this.canvasW / 2, 30 + this.canvasH / 2, 3);
                        if (this.winnerTextFrameId++ >= 2) {
                            this.winnerTextFrameId = 0;
                        }
                    }
                    if (this.seqCounter++ <= 6) break;
                    this.screenId = 5;
                    this.initScreen();
                    new Timer().schedule((TimerTask)new GameTask(this), 10L);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void checkGameOver() throws Exception {
        this.gameOver = this.game.canConnect(this.game.getCurrentPlayer().id);
        if (this.gameOver) {
            this.winner = this.game.getCurrentPlayer();
            this.screenId = 14;
        } else {
            this.gameOver = this.game.hasNoMoreMoves();
            if (this.gameOver) {
                this.screenId = 16;
            }
        }
        if (this.gameOver) {
            this.initScreen();
        }
    }

    public void playSound(String string, int n) {
        try {
            if (this.destroy) {
                return;
            }
            if (string != null && this.currentSound != null && string.equals(this.currentSound)) {
                return;
            }
            this.stopSound();
            if (string == null || !midletConfig.getSound()) {
                return;
            }
            this.playReal(string, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void playReal(String string, int n) {
        try {
            this.currentSound = string;
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/" + this.currentSound);
            this.soundPlayer = Manager.createPlayer((InputStream)inputStream, (String)"audio/midi");
            this.soundPlayer.setLoopCount(n);
            this.soundPlayer.start();
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopSound() {
        try {
            this.currentSound = null;
            if (this.soundPlayer != null) {
                this.soundPlayer.stop();
                this.soundPlayer.close();
            }
            this.soundPlayer = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void hideNotify() {
        this.paused = true;
        this.soundBeforeSuspend = this.currentSound;
        this.stopSound();
    }

    protected void showNotify() {
    }

    private void initScreen() throws Exception {
        if (this.screenId != 10) {
            this.seqCounter = 0;
            this.screenName = null;
            this.dlgInfoText = null;
            this.imgScrBackground = null;
            this.imgScrName = null;
            this.imgScrIcon = null;
            this.imgFour = null;
            this.imgExplosions = null;
            this.imgWinnerBigPiece = null;
            if (this.screenId != 12 && this.screenId != 14 && this.screenId != 15) {
                this.imgGameBoard = null;
                this.imgIllegalMove = null;
            }
        }
        switch (this.screenId) {
            case 1: {
                this.imgScrBackground = Image.createImage((String)"/licensor1.png");
                this.gameTask = new GameTask(this);
                this.gameTimer = new Timer();
                this.gameTimer.schedule((TimerTask)this.gameTask, 500L, 300L);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.imgScrBackground = Image.createImage((String)"/licensor2.png");
                break;
            }
            case 4: {
                this.imgScrBackground = Image.createImage((String)"/background1.png");
                this.imgSplashTitle1 = Image.createImage((String)"/splash_title1.png");
                this.splashTitle1FrameId = 0;
                break;
            }
            case 5: {
                this.inGame = false;
                this.imgWinnerText = null;
                this.playSound("sfxgame.midi", -1);
                if (this.gameTimer != null) {
                    this.gameTimer.cancel();
                }
                this.imgScrBackground = Image.createImage((String)"/background1.png");
                this.screenMenu = new Menu(GlobalDefs.mainMenuItems, null, null, this.menuOffFont, this.menuOnFont, -1);
                this.screenMenuXPos = 50;
                this.screenMenuYPos = 75;
                break;
            }
            case 6: {
                this.screenName = "Solo Play";
                this.imgScrBackground = Image.createImage((String)"/background2.png");
                this.imgScrName = Image.createImage((String)"/scrname_soloplay.png");
                this.imgScrIcon = Image.createImage((String)"/scricon_soloplay.png");
                int[] nArray = new int[]{0, 0, midletConfig.getAILevel()};
                this.screenMenu = new Menu(GlobalDefs.soloPlayMenuItems, nArray, null, this.menuOffFont, this.menuOnFont, 0);
                this.screenMenuXPos = 45;
                this.screenMenuYPos = 100;
                break;
            }
            case 8: {
                this.screenName = "Options";
                this.imgScrBackground = Image.createImage((String)"/background2.png");
                this.imgScrName = Image.createImage((String)"/scrname_options.png");
                this.imgScrIcon = Image.createImage((String)"/scricon_options.png");
                if (this.gameTimer != null) {
                    this.gameTimer.cancel();
                }
                this.screenMenuXPos = 45;
                if (this.inGame) {
                    int[] nArray = new int[]{0, midletConfig.getSound() ? 1 : 0, 0, 0};
                    this.screenMenu = new Menu(GlobalDefs.optionsInGameMenuItems, nArray, null, this.menuOffFont, this.menuOnFont, 0);
                    this.screenMenuYPos = 95;
                    break;
                }
                int[] nArray = new int[]{midletConfig.getSound() ? 1 : 0};
                this.screenMenu = new Menu(GlobalDefs.optionsMenuItems, nArray, null, this.menuOffFont, this.menuOnFont, 0);
                this.screenMenuYPos = 105;
                break;
            }
            case 9: {
                this.helpLine = 0;
                this.screenName = "Help";
                this.imgScrBackground = Image.createImage((String)"/background2.png");
                break;
            }
            case 12: {
                this.inGame = true;
                this.gameOver = false;
                this.winner = null;
                this.imgGameBoard = Image.createImage((String)"/board.png");
                this.imgIllegalMove = Image.createImage((String)"/illegal_move.png");
                this.screenMenu = null;
                this.handPos = 3;
                this.pointerFrameId = 0;
                this.gameTask = new GameTask(this);
                this.gameTimer = new Timer();
                this.gameTimer.schedule((TimerTask)this.gameTask, 500L, 400L);
                this.playSound("sfxgame.midi", -1);
                break;
            }
            case 10: {
                break;
            }
            case 14: {
                this.inGame = false;
                this.imgFour = Image.createImage((String)"/four.png");
                this.fourFrameId = 0;
                if (this.winner == null) {
                    this.playSound("sfxtie.midi", 1);
                    break;
                }
                if (this.winner.type == Player.TYPE_HUMAN) {
                    this.playSound("sfxwin.midi", 1);
                    break;
                }
                this.playSound("sfxlost.midi", 1);
                break;
            }
            case 15: {
                this.imgExplosions = Image.createImage((String)"/explosions.png");
                this.explosionsFrameId = 0;
                break;
            }
            case 16: {
                this.playSound("sfxchips.midi", 1);
                this.imgScrBackground = Image.createImage((String)"/background2.png");
                this.imgWinnerText = this.winner == null ? Image.createImage((String)"/text_itsadraw.png") : this.winner.imgTextWin;
                this.imgWinnerBigPiece = this.winner == null ? Image.createImage((String)"/bigpiece_blackred.png") : this.winner.imgBigPiece;
                this.winnerTextFrameId = 0;
            }
        }
        if (this.screenMenu != null) {
            this.screenMenu.setListener(this);
            this.screenMenu.setDimension(this.canvasW, this.canvasH - this.screenMenuYPos);
        }
    }
}

