/*
 * Decompiled with CFR 0.152.
 */
package rivergon.connect4;

import java.util.Vector;
import javax.microedition.lcdui.Image;
import rivergon.connect4.Connect4Canvas;
import rivergon.connect4.Player;

public final class Connect4Game {
    public static final byte PLAYER_NA = 0;
    public static final byte PLAYER_1 = 1;
    public static final byte PLAYER_2 = -1;
    public static final byte MAX_COLS = 7;
    public static final byte MAX_ROWS = 6;
    public static final byte[] COL_DELTAS = new byte[]{1, 1, -1, 0};
    public static final byte[] ROW_DELTAS = new byte[]{0, 1, 1, 1};
    int currBoardCol;
    int[] colHeight;
    int[][] board;
    int[] c4x;
    int[] c4y;
    int moveCount;
    private int currentPlayer;
    private Vector players = new Vector();

    public Connect4Game() {
        this.init();
    }

    public void init() {
        this.c4x = new int[4];
        this.c4y = new int[4];
        this.colHeight = new int[7];
        this.board = new int[7][6];
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 6; ++j) {
                this.board[i][j] = 0;
            }
            this.colHeight[i] = 0;
        }
    }

    public Connect4Game clone() {
        int n;
        Connect4Game connect4Game = new Connect4Game();
        for (n = 0; n < 7; ++n) {
            for (int i = 0; i < 6; ++i) {
                connect4Game.board[n][i] = this.board[n][i];
            }
        }
        connect4Game.moveCount = this.moveCount;
        connect4Game.currentPlayer = this.currentPlayer;
        for (n = 0; n < this.players.size(); ++n) {
            connect4Game.addPlayer((Player)this.players.elementAt(n));
        }
        return connect4Game;
    }

    public boolean hasNoMoreMoves() {
        return this.moveCount >= 42;
    }

    public int applyMove(int n) {
        int n2;
        for (n2 = 0; n2 < 6 && this.board[n][n2] != 0; ++n2) {
        }
        if (n2 >= 6) {
            return -1;
        }
        ++this.moveCount;
        this.board[n][n2] = this.getCurrentPlayer().id;
        return n2;
    }

    public void undoMove(int n, int n2) {
        --this.moveCount;
        this.board[n][n2] = 0;
    }

    public boolean canConnect(int n) {
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 6 && this.board[i][j] != 0; ++j) {
                if (this.board[i][j] != n) continue;
                int n2 = 0;
                this.c4x[0] = i;
                this.c4y[0] = j;
                for (int k = 0; k < 4; ++k) {
                    int n3 = i + COL_DELTAS[k] * 3;
                    int n4 = j + ROW_DELTAS[k] * 3;
                    if (n3 < 0 || n3 >= 7 || n4 < 0 || n4 >= 6) continue;
                    int n5 = i;
                    int n6 = j;
                    int n7 = 1;
                    n2 = 1;
                    for (int i2 = 0; i2 < 3 && this.board[n5 += COL_DELTAS[k]][n6 += ROW_DELTAS[k]] == n; ++i2) {
                        this.c4x[n2] = n5;
                        this.c4y[n2++] = n6;
                        if (++n7 < 4) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static Connect4Game getInstance(Connect4Canvas connect4Canvas, String string, int n, int n2, String string2, int n3, int n4) {
        Connect4Game connect4Game = new Connect4Game();
        try {
            Player player = new Player(connect4Canvas, connect4Game, 1, string, n, n2, Image.createImage((String)"/pointer_black.png"), Image.createImage((String)"/piece_black.png"), Image.createImage((String)"/turn_black.png"), Image.createImage((String)"/text_blackwins.png"), Image.createImage((String)"/bigpiece_black.png"));
            Player player2 = new Player(connect4Canvas, connect4Game, -1, string2, n3, n4, Image.createImage((String)"/pointer_red.png"), Image.createImage((String)"/piece_red.png"), Image.createImage((String)"/turn_red.png"), Image.createImage((String)"/text_redwins.png"), Image.createImage((String)"/bigpiece_red.png"));
            connect4Game.addPlayer(player);
            connect4Game.addPlayer(player2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return connect4Game;
    }

    public void addPlayer(Player player) {
        this.players.addElement(player);
    }

    public Player getCurrentPlayer() {
        return (Player)this.players.elementAt(this.currentPlayer);
    }

    public Player getNextPlayer(int n) {
        int n2 = this.players.size();
        for (int i = 0; i < n2; ++i) {
            Player player = (Player)this.players.elementAt(i);
            if (player.id != n) continue;
            return i + 1 < n2 ? (Player)this.players.elementAt(i + 1) : (Player)this.players.elementAt(0);
        }
        return null;
    }

    public Player nextPlayer() {
        ++this.currentPlayer;
        if (this.currentPlayer >= this.players.size()) {
            this.currentPlayer = 0;
        }
        return this.getCurrentPlayer();
    }
}

