/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import com.nokia.mid.ui.FullCanvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Intro
extends FullCanvas {
    private Sprite[] splash = new Sprite[2];
    private int splashState = 0;
    private Sprite hugoBlink;
    private Sprite hugoBubble;
    private Sprite hugoKnock;
    private Sprite hugo;
    private Sprite scrollArrow;
    private int curFrame;
    private int scrollOffset = 0;
    private int minScrollOffset;
    private int maxScrollOffset;
    private static final int[] headEaseInOut = new int[]{0, 0, 0, 0, 0, 0, 0, 30, 60, 83, 95, 100, 100};
    private static final int headSlideXOut = 110;
    private static final int headSlideXIn = 77;
    private static final int headSlideYOut = 209;
    private static final int headSlideYIn = 96;
    private int blinkStart = -100;
    private static final int blinkLength = 3;
    private static final int[] knockframes = new int[]{-2, -1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, -1, -2};
    private Sound knockSound;
    private boolean knockSoundOk = true;
    private int frameDirection;
    private boolean initialized = false;
    private boolean running;
    private int bubbleTextX = 14;
    private int bubbleTextY = 103;
    private int bubbleTextWidth = 60;
    private int bubbleTextHeight = 75;
    private String bubbleText;
    private String[] bubbleTextTokens;
    private int[] bubbleTextTokensX;
    private int[] bubbleTextTokensWidth;
    private int[] bubbleTextTokensY;
    private int textLines;
    private boolean scrollUp = false;
    private boolean scrollDown = false;
    private Sprite bg;
    private boolean gamePaintMode;
    private Game game;
    private Image publisher;
    private boolean firstRun = true;
    private int[] xPoints = new int[]{0, 176, 176, 0};
    private int[] yPoints = new int[]{0, 0, 208, 208};

    public Intro() {
        try {
            this.publisher = Image.createImage((String)"/res/publisher.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.splash[0] = Setup.getSprite("itesplash.kspr");
            this.splash[1] = Setup.getSprite("kiloosplash.kspr");
            this.bg = HugoInTheSnow.bg;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.scrollArrow = Setup.getSprite("introArrow.kspr");
        this.hugoBlink = Setup.getSprite("introBlink.kspr");
        this.hugoBlink.setPosition(107, 138);
        this.hugoBlink.setVisible(false);
        this.hugoKnock = Setup.getSprite("introBank.kspr");
        this.hugoKnock.setVisible(false);
        this.hugoBubble = Setup.getSprite("introBubble.kspr");
        this.hugoBubble.setPosition(0, 76);
        this.hugoBubble.setVisible(false);
        this.hugo = Setup.getSprite("introHugo.kspr");
        this.knockSound = Setup.loadWave("/res/bank.wav", 1590);
        this.curFrame = 0;
        this.blinkStart = -100;
    }

    public synchronized void paint(Graphics graphics) {
        if (!this.initialized) {
            return;
        }
        if (this.publisher != null) {
            graphics.setColor(255, 255, 255);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.drawImage(this.publisher, (this.getWidth() - this.publisher.getWidth()) / 2, (this.getHeight() - this.publisher.getHeight()) / 2, 20);
            return;
        }
        if (this.splash != null && this.splashState < this.splash.length) {
            graphics.setColor(255, 255, 255);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.splash[this.splashState].setPosition((this.getWidth() - this.splash[this.splashState].getWidth()) / 2, (this.getHeight() - this.splash[this.splashState].getHeight()) / 2);
            this.splash[this.splashState].paint(graphics);
        } else {
            graphics.setColor(0, 0, 0);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setClip(0, 0, HugoInTheSnow.bg.getWidth(), HugoInTheSnow.bg.getHeight());
            graphics.translate(0, (this.getHeight() - HugoInTheSnow.bg.getHeight()) / 2);
            this.bg.paint(graphics);
            this.hugo.paint(graphics);
            this.hugoBlink.paint(graphics);
            this.hugoKnock.paint(graphics);
            this.hugoBubble.paint(graphics);
            if (this.hugoBubble.isVisible()) {
                graphics.setFont(HugoInTheSnow.getFontSmall());
                graphics.setClip(0, this.bubbleTextY - 10, 176, this.bubbleTextHeight + 20);
                int n = 0;
                while (n < this.bubbleTextTokens.length) {
                    int n2;
                    int n3 = this.bubbleTextTokensY[n] + this.scrollOffset;
                    graphics.setColor(0, 0, 0);
                    if (n3 < 0) {
                        n2 = n3 + 10;
                        if (n2 <= 0) {
                            n2 = 0;
                        }
                        n2 = 10 - n2;
                        graphics.setColor(n2 * 255 / 10, n2 * 255 / 10, n2 * 255 / 10);
                    }
                    if (n3 > this.bubbleTextHeight - 10) {
                        n2 = n3 - (this.bubbleTextHeight - 10);
                        if (n2 <= 0) {
                            n2 = 0;
                        }
                        if (n2 > 10) {
                            n2 = 10;
                        }
                        graphics.setColor(n2 * 255 / 10, n2 * 255 / 10, n2 * 255 / 10);
                    }
                    graphics.drawString(this.bubbleTextTokens[n], this.bubbleTextX + this.bubbleTextTokensX[n], this.bubbleTextY + this.bubbleTextTokensY[n] + this.scrollOffset, 20);
                    ++n;
                }
                graphics.setClip(0, 0, 176, 208);
                if (this.textLines * HugoInTheSnow.getFontSmall().getHeight() > this.bubbleTextHeight) {
                    this.scrollArrow.setFrame(0);
                    this.scrollArrow.setPosition(this.bubbleTextX + (this.bubbleTextWidth - this.scrollArrow.width) / 2, 7 + this.bubbleTextY + this.bubbleTextHeight + 2);
                    if (this.scrollOffset > -this.maxScrollOffset) {
                        this.scrollArrow.paint(graphics);
                    }
                    this.scrollArrow.setFrame(1);
                    this.scrollArrow.setPosition(this.bubbleTextX + (this.bubbleTextWidth - this.scrollArrow.width) / 2, -7 + this.bubbleTextY - this.scrollArrow.height - 2);
                    if (this.scrollOffset < this.minScrollOffset) {
                        this.scrollArrow.paint(graphics);
                    }
                }
            }
            this.curFrame += this.frameDirection;
            if (this.curFrame <= 0 && this.firstRun) {
                DirectGraphics directGraphics = DirectUtils.getDirectGraphics((Graphics)graphics);
                directGraphics.fillPolygon(this.xPoints, 0, this.yPoints, 0, 4, -2013265920);
                graphics.setFont(Font.getFont((int)0, (int)1, (int)16));
                graphics.setColor(0, 0, 0);
                graphics.drawString(Language.get("PleaseWait"), (177 - graphics.getFont().stringWidth(Language.get("PleaseWait"))) / 2, 1 + (208 - graphics.getFont().getHeight()) / 2, 20);
                graphics.setColor(255, 255, 255);
                graphics.drawString(Language.get("PleaseWait"), (176 - graphics.getFont().stringWidth(Language.get("PleaseWait"))) / 2, (208 - graphics.getFont().getHeight()) / 2, 20);
            }
        }
    }

    public void destroy() {
        int n = 0;
        while (n < this.splash.length) {
            this.splash[n] = null;
            ++n;
        }
        this.splash = null;
        System.gc();
    }

    public void setGame(Game game) {
        this.game = game;
    }

    public void setGamePaintMode(boolean bl) {
        this.gamePaintMode = bl;
    }

    public void run(String string, boolean bl) {
        int n;
        int n2;
        if (this.splash != null) {
            if (this.publisher != null) {
                this.initialized = true;
                this.repaint();
                try {
                    Thread.sleep(1500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.publisher = null;
            n2 = 0;
            while (n2 < this.splash.length) {
                this.initialized = true;
                this.splashState = n2;
                if (!this.gamePaintMode) {
                    this.repaint();
                } else {
                    this.game.repaint();
                }
                try {
                    Thread.sleep(1500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
        }
        this.initialized = false;
        this.splashState = Integer.MAX_VALUE;
        this.textLines = 0;
        n2 = 0;
        String string2 = string;
        int n3 = 0;
        while (n3 < string2.length()) {
            if (string2.charAt(n3) == ' ') {
                ++n2;
            }
            ++n3;
        }
        this.bubbleTextTokens = new String[++n2];
        this.bubbleTextTokensX = new int[n2];
        this.bubbleTextTokensWidth = new int[n2];
        this.bubbleTextTokensY = new int[n2];
        n2 = 0;
        int n4 = 0;
        String string3 = "";
        while (n2 < string2.length()) {
            string3 = string3 + string2.charAt(n2);
            if (string2.charAt(n2) == ' ') {
                this.bubbleTextTokens[n4++] = string3;
                string3 = "";
            }
            ++n2;
        }
        this.bubbleTextTokens[n4++] = string3;
        int n5 = 0;
        int n6 = 0;
        Font font = HugoInTheSnow.getFontSmall();
        int n7 = 0;
        while (n7 < this.bubbleTextTokens.length) {
            if (n5 + font.stringWidth(this.bubbleTextTokens[n7]) > this.bubbleTextWidth) {
                n5 = 0;
                n6 += font.getHeight();
            }
            this.bubbleTextTokensX[n7] = n5;
            this.bubbleTextTokensY[n7] = n6;
            this.bubbleTextTokensWidth[n7] = font.stringWidth(this.bubbleTextTokens[n7]);
            n5 += font.stringWidth(this.bubbleTextTokens[n7]);
            ++n7;
        }
        n2 = 0;
        while (n2 < this.bubbleTextTokens.length) {
            n = n2;
            while (this.bubbleTextTokensY[n2] == this.bubbleTextTokensY[n]) {
                if (++n2 >= this.bubbleTextTokens.length) break;
            }
            int n8 = 0;
            int n9 = n;
            while (n9 < n2) {
                n8 += this.bubbleTextTokensWidth[n9];
                ++n9;
            }
            int n10 = n;
            while (n10 < n2) {
                int n11 = n10++;
                this.bubbleTextTokensX[n11] = this.bubbleTextTokensX[n11] + (this.bubbleTextWidth - n8) / 2;
            }
            ++this.textLines;
        }
        this.minScrollOffset = 0;
        this.maxScrollOffset = this.textLines * HugoInTheSnow.getFontSmall().getHeight() - this.bubbleTextHeight;
        this.scrollOffset = 0;
        this.curFrame = 0;
        this.frameDirection = 1;
        this.running = true;
        while (this.running) {
            this.hugo.setVisible(true);
            if (this.curFrame < headEaseInOut.length && this.curFrame >= 0) {
                this.hugo.setPosition(110 + -33 * headEaseInOut[this.curFrame] / 100, 209 + -113 * headEaseInOut[this.curFrame] / 100);
            } else {
                this.hugo.setPosition(77, 96);
                if (!bl) {
                    this.hugoBubble.setVisible(true);
                }
            }
            if (bl) {
                if (this.curFrame == headEaseInOut.length + 13 || this.curFrame == headEaseInOut.length + 27) {
                    this.blinkStart = this.curFrame;
                }
                this.hugoBlink.setVisible(false);
                if (this.curFrame >= this.blinkStart && this.curFrame < this.blinkStart + 3) {
                    this.hugoBlink.setVisible(true);
                }
                if ((n = this.curFrame - headEaseInOut.length - 47) >= knockframes.length + 20) {
                    this.hugoBubble.setVisible(true);
                }
                this.hugoKnock.setVisible(false);
                if (n >= 0 && n < knockframes.length) {
                    this.hugoKnock.setVisible(true);
                    if (knockframes[n] == -2) {
                        this.hugoKnock.setFrame(0);
                        this.hugoKnock.setPosition(81, 191);
                        this.knockSoundOk = true;
                    } else if (knockframes[n] == -1) {
                        this.hugoKnock.setFrame(0);
                        this.hugoKnock.setPosition(81, 171);
                        this.knockSoundOk = true;
                    } else if (knockframes[n] == 0) {
                        this.hugoKnock.setFrame(0);
                        this.hugoKnock.setPosition(81, 161);
                        this.knockSoundOk = true;
                    } else if (knockframes[n] == 1) {
                        this.hugoKnock.setFrame(1);
                        this.hugoKnock.setPosition(70, 152);
                        if (this.knockSoundOk) {
                            try {
                                Setup.playSound(this.knockSound);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.knockSoundOk = false;
                        }
                    }
                }
            }
            this.initialized = true;
            if (!this.gamePaintMode) {
                this.repaint();
            } else {
                this.game.repaint();
            }
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.scrollUp) {
                this.scrollOffset += 3;
                if (this.scrollOffset > this.minScrollOffset) {
                    this.scrollOffset = this.minScrollOffset;
                }
            }
            if (!this.scrollDown) continue;
            this.scrollOffset -= 3;
            if (this.scrollOffset >= -this.maxScrollOffset) continue;
            this.scrollOffset = -this.maxScrollOffset;
        }
        this.hugoKnock.setVisible(false);
        this.hugoBubble.setVisible(false);
        this.hugoBlink.setVisible(false);
        this.frameDirection = -1;
        this.curFrame = this.curFrame = headEaseInOut.length - 1;
        while (this.curFrame > 0) {
            this.hugo.setPosition(110 + -33 * headEaseInOut[this.curFrame] / 100, 209 + -113 * headEaseInOut[this.curFrame] / 100);
            if (!this.gamePaintMode) {
                this.repaint();
            } else {
                this.game.repaint();
            }
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.firstRun = false;
    }

    protected synchronized void keyReleased(int n) {
        if (HugoInTheSnow.checkKey(n, HugoInTheSnow.KEY_UP)) {
            this.scrollUp = false;
            this.scrollDown = false;
        }
        if (HugoInTheSnow.checkKey(n, HugoInTheSnow.KEY_DOWN)) {
            this.scrollUp = false;
            this.scrollDown = false;
        }
    }

    protected synchronized void keyPressed(int n) {
        if (HugoInTheSnow.checkKey(n, HugoInTheSnow.KEY_LEFT_SOFTKEY) || HugoInTheSnow.checkKey(n, HugoInTheSnow.KEY_ENTER)) {
            this.running = false;
        }
        if (this.textLines * HugoInTheSnow.getFontSmall().getHeight() > this.bubbleTextHeight) {
            if (HugoInTheSnow.checkKey(n, HugoInTheSnow.KEY_UP)) {
                this.scrollUp = true;
                this.scrollDown = false;
            }
            if (HugoInTheSnow.checkKey(n, HugoInTheSnow.KEY_DOWN)) {
                this.scrollUp = false;
                this.scrollDown = true;
            }
        }
    }
}

