/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class Setup {
    public static String[][] fileLists = new String[][]{{"kiloosplash.kspr", "itesplash.kspr", "introBlink.kspr", "introBank.kspr", "introHugo.kspr", "introBubble.kspr", "introArrow.kspr", "baggrund.kspr"}, {"haender.kspr", "hex.kspr", "sigtekorn.kspr", "snebolde.kspr", "splats.kspr", "points.kspr", "spof.kspr", "hexFall.kspr", "handTilbage.kspr", "handHoejre.kspr", "bgplade.kspr", "filter.kspr"}};
    private static String[] fileList;
    private static boolean[] spriteCopyList;
    private static Sprite[] spriteList;

    public static final int convertByte(byte by) {
        if (by < 0) {
            return by + 256;
        }
        return by;
    }

    public static void load(int n) {
        spriteCopyList = null;
        spriteList = null;
        System.gc();
        fileList = fileLists[n];
        spriteCopyList = new boolean[fileList.length];
        spriteList = new Sprite[spriteCopyList.length];
        String[] stringArray = new String[]{"/res/intro.dat", "/res/game.dat"};
        try {
            InputStream inputStream = "".getClass().getResourceAsStream(stringArray[n]);
            byte[] byArray = new byte[8];
            Sprite sprite = null;
            int n2 = 0;
            while (n2 < fileList.length) {
                inputStream.read(byArray);
                if (Setup.convertByte(byArray[3]) == 17) {
                    int n3 = Setup.convertByte(byArray[2]);
                    int n4 = (Setup.convertByte(byArray[4]) << 8) + Setup.convertByte(byArray[5]);
                    int n5 = (Setup.convertByte(byArray[6]) << 8) + Setup.convertByte(byArray[7]);
                    sprite = new Sprite();
                    sprite.frames = new Image[n3];
                    sprite.width = n4;
                    sprite.height = n5;
                    sprite.frameCount = n3;
                    int n6 = 0;
                    while (n6 < n3) {
                        int n7 = (Setup.convertByte((byte)inputStream.read()) << 24) + (Setup.convertByte((byte)inputStream.read()) << 16) + (Setup.convertByte((byte)inputStream.read()) << 8) + Setup.convertByte((byte)inputStream.read());
                        byte[] byArray2 = new byte[n7];
                        int n8 = 0;
                        int n9 = 0;
                        while ((n8 = inputStream.read(byArray2, n9, byArray2.length - n9)) != -1 && (n9 += n8) < byArray2.length) {
                        }
                        sprite.frames[n6] = Image.createImage((byte[])byArray2, (int)0, (int)byArray2.length);
                        ++n6;
                    }
                } else {
                    System.out.println("Unknown sprite");
                }
                Setup.spriteCopyList[n2] = false;
                Setup.spriteList[n2] = sprite;
                ++n2;
            }
            inputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Sprite getSprite(String string) {
        int n = 0;
        while (n < fileList.length) {
            if (string.equals(fileList[n])) break;
            ++n;
        }
        if (n < fileList.length) {
            if (!spriteCopyList[n]) {
                Setup.spriteCopyList[n] = true;
                return spriteList[n];
            }
            return new Sprite(spriteList[n]);
        }
        System.out.println(string + " not found.");
        return null;
    }

    public static Sound loadSound(String string) {
        try {
            InputStream inputStream = "".getClass().getResourceAsStream(string);
            byte[] byArray = new byte[6];
            inputStream.read(byArray);
            int n = Setup.convertByte(byArray[0]);
            int n2 = (Setup.convertByte(byArray[2]) << 8) + Setup.convertByte(byArray[3]);
            int n3 = (Setup.convertByte(byArray[4]) << 8) + Setup.convertByte(byArray[5]);
            byte[] byArray2 = new byte[n2 * n3 >> 3];
            inputStream.read(byArray2);
            inputStream.close();
            return new Sound(byArray2, 1);
        }
        catch (Exception exception) {
            System.out.println("error: " + string);
            return null;
        }
    }

    public static Sound loadWave(String string, int n) {
        try {
            InputStream inputStream = "".getClass().getResourceAsStream(string);
            byte[] byArray = new byte[n];
            inputStream.read(byArray);
            inputStream.close();
            Sound sound = new Sound(byArray, 5);
            sound.init(byArray, 5);
            return sound;
        }
        catch (Exception exception) {
            System.out.println("error: " + string);
            return null;
        }
    }

    public static void playSound(Sound sound) {
        if (RMS.getAsInteger("sounds") == 0) {
            sound.play(1);
        }
    }

    public static void stopSound(Sound sound) {
        if (RMS.getAsInteger("sounds") == 0) {
            sound.stop();
        }
    }
}

