/*
 * Decompiled with CFR 0.152.
 */
package com.bsg.nss.nokiacolor;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class Monster {
    protected Image monsterImages;
    protected int xPos;
    protected int origXPos;
    protected int yPos;
    protected int origYPos;
    protected int dx;
    protected int origDX;
    protected int dy;
    protected int origDY;
    protected int height;
    protected int halfHeight;
    protected int width;
    protected int halfWidth;
    protected int currentMove;
    protected int currentFrame;
    protected int levelHeight;
    protected boolean active;
    protected boolean dying;
    protected boolean dead;
    protected final int M_UP;
    protected final int M_DOWN;
    protected final int M_LEFT;
    protected final int M_RIGHT;
    protected final int M_DEAD;
    protected final int M_JUMP_LEFT;
    protected final int M_JUMP_RIGHT;
    protected static final int JUMPING_MONSTER = 1;
    protected static final int FLYING_MONSTER = 2;
    protected static final int LINE_MONSTER = 3;

    protected Monster(Image image, int n, int n2, int n3, int n4, int n5) {
        this.M_UP = 0;
        this.M_DOWN = 1;
        this.M_LEFT = 2;
        this.M_RIGHT = 3;
        this.M_DEAD = 4;
        this.M_JUMP_LEFT = 5;
        this.M_JUMP_RIGHT = 6;
        this.monsterImages = image;
        this.xPos = n * 16;
        this.origXPos = n * 16;
        this.yPos = n2 * 16;
        this.origYPos = n2 * 16;
        this.levelHeight = n5;
        this.dx = n3;
        this.origDX = n3;
        this.dy = n4;
        this.origDY = n4;
        this.height = 16;
        this.halfHeight = this.height / 2;
        this.width = 16;
        this.halfWidth = this.width / 2;
        this.currentMove = 3;
        this.currentFrame = 0;
        this.active = true;
    }

    public void reset() {
        if (!this.dying && !this.dead) {
            this.xPos = this.origXPos;
            this.yPos = this.origYPos;
            this.dx = this.origDX;
            this.dy = this.origDY;
            this.dying = false;
            this.dead = false;
        }
        this.active = true;
    }

    public void checkActive(int n, int n2, int n3, int n4) {
        this.active = this.xPos < -n + n3 + 50 && this.xPos > -n - 50 && this.yPos < -n2 + n4 + 50 && this.yPos > -n2 - 50;
    }

    public boolean collide(int n, int n2) {
        return !this.dying && this.xPos - 5 <= n && this.xPos + this.width + 5 >= n && this.yPos - 5 <= n2 && this.yPos + this.height + 5 >= n2;
    }

    public boolean shotCollide(int n, int n2, int n3, int n4) {
        if (!this.dying && (n2 >= this.xPos && n2 <= this.xPos + this.width || n >= this.xPos && n <= this.xPos + this.width || n2 < this.xPos && n > this.xPos + this.width) && (n4 >= this.yPos && n4 <= this.yPos + this.height || n3 >= this.yPos && n3 <= this.yPos + this.height || n4 < this.yPos && n3 > this.yPos + this.height)) {
            this.dying();
            return true;
        }
        return false;
    }

    public void dying() {
        this.dying = true;
        this.dy = -8;
        this.dx = 0;
        this.currentMove = 4;
        this.currentFrame = 0;
    }

    public abstract void move();

    public abstract void paint(Graphics var1, int var2, int var3);

    static {
        JUMPING_MONSTER = 1;
        FLYING_MONSTER = 2;
        LINE_MONSTER = 3;
    }
}

