/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.FullCanvas;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class OmegaMission
extends MIDlet
implements CommandListener {
    static final boolean REAL_DEVICE = false;
    static final boolean DEBUG = true;
    Display display;
    Displayable currentDisplayable;
    Displayable previousDisplayable;
    private Form loadingForm;
    private Form helpForm;
    private Form aboutForm;
    Form resultForm;
    private SplashCanvas splashCanvas;
    MainCanvas mainCanvas;
    private OmegaMissionCanvas omegaMissionCanvas;
    private Thread thread;
    static Gauge gauge;
    private boolean firstTime;
    private Command solveCommand;
    private Command exitCommand;
    Command backCommand;
    private byte level = 1;
    public static int highScore;
    final String APP_VERSION = "version " + this.getAppProperty("MIDlet-Version");
    final String APP_NAME = this.getAppProperty("MIDlet-Name");
    final String APP_SPLASH;
    final String APP_MENU;
    final String MAIN_STR = this.getAppProperty("MIDlet-Description");
    final String ABOUT_STR = this.APP_NAME + ", version " + this.getAppProperty("MIDlet-Version") + "\nCopyright 2003 Zindell Technologies, Ltd. All rights reserved. Developed by " + this.getAppProperty("MIDlet-Vendor") + " " + this.getAppProperty("MIDlet-Info-URL") + "\nSoftware is provided \"AS IS\" without warranty of any kind. In no event, shall we be liable for any claim, damages or other liability.";
    final String HELP_STR = this.getAppProperty("MIDlet-Description") + " You are John Striker. You have graduated Magna cum Laude from the military academy. Recently, you have been chosen by the UN special agency to serve as the commander of Omega mission. Following this UN special agency decision your rank was raised to Captain! " + "The dangerous aliens, that live on planet Omega, created a new weapon. These aliens plan to use this secret new weapon to destroy Earth's population and use Earth for their needs. " + "In 1972, an alien space ship crashed on Earth. That space ship landed on one of the Caribbean islands. This space ship has been repaired by UN special secret agents and using it is the only way to save Earth. " + "Use your navigation keys in order to move the ship up/down/left and right. Press the \n'1' - to shoot with your laser,\n'2' - to shoot rockets,\n'3' - to throw bombs,\n'4' - to turn power shield on,\n'5' to jump with your ship forward/backward, and\n'6' to throw smart bombs.\nYou can use your power shield only 3 times in one level. You have 5 smart bombs for one level only.";

    public OmegaMission() {
        this.APP_SPLASH = "/OmegaMissionSplash.png";
        this.APP_MENU = "/OmegaMenu.png";
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.backCommand) {
            this.currentDisplayable = this.mainCanvas;
            this.display.setCurrent(this.currentDisplayable);
        }
    }

    public void startApp() {
        if (this.display == null) {
            this.thread = new Thread(){

                public void run() {
                    try {
                        OmegaMission.this.display = Display.getDisplay((MIDlet)OmegaMission.this);
                        OmegaMission.this.loadingForm = new Form("Loading...");
                        OmegaMission.this.currentDisplayable = OmegaMission.this.loadingForm;
                        gauge = new Gauge("Please wait...", false, 10, 0);
                        OmegaMission.this.loadingForm.append((Item)gauge);
                        gauge.setValue(0);
                        OmegaMission.this.display.setCurrent((Displayable)OmegaMission.this.loadingForm);
                        OmegaMission.this.exitCommand = new Command("Exit", 7, 2);
                        OmegaMission.this.backCommand = new Command("Back", 2, 2);
                        OmegaMission.this.firstTime = true;
                        OmegaMission.this.loadHighScore();
                        gauge.setValue(1);
                        OmegaMission.this.omegaMissionCanvas = new OmegaMissionCanvas(OmegaMission.this);
                        gauge.setValue(4);
                        OmegaMission.this.omegaMissionCanvas.init(1);
                        gauge.setValue(7);
                        OmegaMission.this.mainCanvas = new MainCanvas();
                        gauge.setValue(8);
                        OmegaMission.this.aboutForm = new Form("About");
                        OmegaMission.this.aboutForm.append(OmegaMission.this.ABOUT_STR);
                        OmegaMission.this.aboutForm.addCommand(OmegaMission.this.backCommand);
                        OmegaMission.this.aboutForm.setCommandListener((CommandListener)OmegaMission.this);
                        gauge.setValue(9);
                        OmegaMission.this.helpForm = new Form("Help");
                        OmegaMission.this.helpForm.append(OmegaMission.this.HELP_STR);
                        OmegaMission.this.helpForm.addCommand(OmegaMission.this.backCommand);
                        OmegaMission.this.helpForm.setCommandListener((CommandListener)OmegaMission.this);
                        gauge.setValue(10);
                        OmegaMission.this.splashCanvas = new SplashCanvas();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            };
            this.thread.start();
        } else {
            this.display.setCurrent(this.currentDisplayable);
        }
    }

    public void pauseApp() {
        if (this.currentDisplayable != this.mainCanvas) {
            this.currentDisplayable = this.display.getCurrent();
        }
    }

    public void exit() {
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void destroyApp(boolean bl) {
        this.display = null;
        this.currentDisplayable = null;
        this.helpForm = null;
        this.aboutForm = null;
        this.mainCanvas = null;
        this.loadingForm = null;
        gauge = null;
        this.exitCommand = null;
        this.backCommand = null;
        this.omegaMissionCanvas = null;
        this.splashCanvas = null;
        this.thread = null;
    }

    static byte[] calcScore(int n) {
        byte[] byArray = new byte[]{(byte)(n / 10000), (byte)(n % 10000 / 100), (byte)(n % 100)};
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadHighScore() {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"OmegaMScores", (boolean)true);
            if (recordStore.getNumRecords() == 1) {
                byte[] byArray = recordStore.getRecord(1);
                highScore = byArray[0] * 10000 + byArray[1] * 100 + byArray[2];
            } else {
                if (recordStore.getNumRecords() > 0) {
                    this.deleteScoresDatabase();
                }
                recordStore = RecordStore.openRecordStore((String)"OmegaMScores", (boolean)true);
                byte[] byArray = OmegaMission.calcScore(0);
                recordStore.addRecord(byArray, 0, 3);
                highScore = 0;
            }
        }
        catch (RecordStoreException recordStoreException) {
            this.deleteScoresDatabase();
            recordStoreException.printStackTrace();
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {}
        }
    }

    private void deleteScoresDatabase() {
        try {
            RecordStore.deleteRecordStore((String)"OmegaMScores");
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
    }

    static {
        highScore = 0;
    }

    private class MainCanvas
    extends FullCanvas {
        private int width;
        private int height;
        private Image menuImage;
        private Image soundOnImage;
        private Image soundOffImage;
        private int[] points = new int[]{18, 43, 68, 93, 118, 143, 168};
        private int selected = 1;
        private boolean bug = false;

        private MainCanvas() {
            this.width = this.getWidth();
            this.height = this.getHeight();
            try {
                this.menuImage = Image.createImage((String)"/OmegaMenu.png");
                this.soundOnImage = Image.createImage((String)"/on.png");
                this.soundOffImage = Image.createImage((String)"/off.png");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        protected void keyPressed(int n) {
            if (n == -6 || n == -7) {
                this.bug = true;
            } else if (n == -2) {
                ++this.selected;
                if (this.selected > this.points.length - 1) {
                    this.selected = this.points.length - 1;
                }
            } else if (n == -1) {
                --this.selected;
                if (this.selected < 0) {
                    this.selected = 0;
                }
            } else if (n == -5) {
                switch (this.selected) {
                    case 0: {
                        if (((OmegaMission)OmegaMission.this).omegaMissionCanvas.level == 0) {
                            OmegaMission.this.omegaMissionCanvas.init(1);
                        }
                        OmegaMission.this.currentDisplayable = OmegaMission.this.omegaMissionCanvas;
                        OmegaMission.this.display.setCurrent(OmegaMission.this.currentDisplayable);
                        break;
                    }
                    case 1: {
                        OmegaMission.this.omegaMissionCanvas.init(1);
                        OmegaMission.this.currentDisplayable = OmegaMission.this.omegaMissionCanvas;
                        OmegaMission.this.display.setCurrent(OmegaMission.this.currentDisplayable);
                        break;
                    }
                    case 2: {
                        String string = "Best result : " + highScore;
                        Alert alert = new Alert("High Scores:", string, null, AlertType.INFO);
                        alert.setTimeout(4000);
                        OmegaMission.this.display.setCurrent(alert, (Displayable)this);
                        break;
                    }
                    case 3: {
                        ((OmegaMission)OmegaMission.this).omegaMissionCanvas.sound = !((OmegaMission)OmegaMission.this).omegaMissionCanvas.sound;
                        break;
                    }
                    case 4: {
                        this.bug = true;
                        break;
                    }
                    case 5: {
                        OmegaMission.this.currentDisplayable = OmegaMission.this.helpForm;
                        OmegaMission.this.display.setCurrent(OmegaMission.this.currentDisplayable);
                        break;
                    }
                    case 6: {
                        OmegaMission.this.currentDisplayable = OmegaMission.this.aboutForm;
                        OmegaMission.this.display.setCurrent(OmegaMission.this.currentDisplayable);
                    }
                }
            }
            if (this.bug) {
                OmegaMission.this.exit();
                return;
            }
            this.repaint();
            this.serviceRepaints();
        }

        protected void paint(Graphics graphics) {
            graphics.setColor(255, 102, 0);
            graphics.fillRect(0, 0, this.width, this.height);
            graphics.setColor(255, 255, 0);
            graphics.fillRect(0, this.points[this.selected], this.width, 23);
            graphics.drawImage(this.menuImage, 0, 0, 20);
            if (((OmegaMission)OmegaMission.this).omegaMissionCanvas.sound) {
                graphics.drawImage(this.soundOnImage, 103, 90, 20);
            } else {
                graphics.drawImage(this.soundOffImage, 103, 90, 20);
            }
        }
    }

    private class SplashCanvas
    extends FullCanvas {
        private Timer timer = new Timer();
        private Image splashImg;
        private int width = this.getWidth();
        private int height = this.getHeight();
        private int x;
        private int y1;
        private Font bigFont = Font.getFont((int)0, (int)1, (int)0);
        private Font smallFont = Font.getFont((int)0, (int)0, (int)0);

        private SplashCanvas() {
            try {
                this.splashImg = Image.createImage((String)"/OmegaMissionSplash.png");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.x = this.getWidth() / 2;
            this.y1 = this.getHeight() / 2;
            OmegaMission.this.display.setCurrent((Displayable)this);
        }

        protected void showNotify() {
            this.timer.schedule((TimerTask)new CountDown(), 4000L);
        }

        protected void keyPressed(int n) {
            if (n == -5 || n == -7 || n == -6) {
                this.dismiss();
            }
        }

        protected void pointerPressed(int n, int n2) {
            this.dismiss();
        }

        protected void paint(Graphics graphics) {
            graphics.drawImage(this.splashImg, this.x, this.y1, 3);
        }

        private void dismiss() {
            this.timer.cancel();
            OmegaMission.this.currentDisplayable = OmegaMission.this.mainCanvas;
            OmegaMission.this.display.setCurrent(OmegaMission.this.currentDisplayable);
        }

        private class CountDown
        extends TimerTask {
            private CountDown() {
            }

            public void run() {
                SplashCanvas.this.dismiss();
            }
        }
    }
}

