/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import com.nokia.mid.ui.FullCanvas;
import java.io.DataInputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class GameCanvas
extends FullCanvas
implements Runnable {
    public static final int OFSET = -8;
    public static final int ONSIGN = -1;
    public static final int ONTITLE = 0;
    public static final int ONGAME = 1;
    public static final int STGOFX = 16;
    public static final int STGOFY = 16;
    public static int trX;
    public static int trY;
    private boolean resumeFlag = false;
    private int iS;
    private int pS;
    private int tgS;
    private int mV;
    private int sC;
    private int dR;
    private int lV;
    private int dV;
    private int eC;
    private int bR;
    private int kY;
    private int bobP;
    private int bAnim;
    private int mH;
    private int mS;
    private int eB;
    private int dB;
    private boolean bF;
    private boolean sF;
    private boolean kF;
    private boolean gF;
    private boolean dF;
    private boolean upA;
    private boolean upB;
    private Bobble pA;
    private Font sFont;
    private static final int[][] ARW1;
    private static final int[][] ARW2;
    private PzBb4Nokia owM;
    private Image pI;
    private Image sI;
    private Image nI;
    private Image gI;
    private Image eI;
    private Image rI;
    private Image tI;
    public Image ofSc1;
    public Image ofSc2;
    public Graphics ofSg2;
    public Image ofSc3;
    public Image[] bomI;
    public Image[] awaI;
    public Image[] plyI;
    public Image[] numI;
    private int aWidth;
    private Sound[] sD;

    public GameCanvas(PzBb4Nokia pzBb4Nokia) {
        this.owM = pzBb4Nokia;
        this.loadImages();
        this.setBGImage();
        this.sD = new Sound[3];
        this.setSound("ers.wav", 2);
    }

    private void setSound(String string, int n) {
        try {
            DataInputStream dataInputStream = new DataInputStream(Class.forName("PzBb4Nokia").getResourceAsStream("/" + string));
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.read();
            int n4 = dataInputStream.read();
            int n5 = dataInputStream.read();
            int n6 = dataInputStream.read();
            int n7 = (n6 << 24) + (n5 << 16) + (n4 << 8) + (n3 << 0) + 8;
            dataInputStream.close();
            dataInputStream = new DataInputStream(Class.forName("PzBb4Nokia").getResourceAsStream("/" + string));
            byte[] byArray = new byte[n7];
            dataInputStream.read(byArray, 0, n7);
            dataInputStream.close();
            this.sD[n] = new Sound(byArray, 5);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean loadImages() {
        try {
            this.awaI = new Image[8];
            int n = 0;
            while (n < this.awaI.length) {
                this.awaI[n] = Image.createImage((String)("/awa" + (n + 1) + ".png"));
                ++n;
            }
            this.numI = new Image[10];
            int n2 = 0;
            while (n2 < this.numI.length) {
                this.numI[n2] = Image.createImage((String)("/num" + n2 + ".png"));
                ++n2;
            }
            this.bomI = new Image[6];
            int n3 = 0;
            while (n3 < this.bomI.length) {
                this.bomI[n3] = Image.createImage((String)("/bom" + (n3 + 1) + ".png"));
                ++n3;
            }
            this.plyI = new Image[5];
            this.plyI[0] = Image.createImage((String)"/bub1.png");
            this.plyI[1] = Image.createImage((String)"/bub2.png");
            this.plyI[2] = Image.createImage((String)"/bub3.png");
            this.plyI[3] = Image.createImage((String)"/bub4.png");
            this.plyI[4] = Image.createImage((String)"/bub5.png");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean setBGImage() {
        try {
            this.ofSc1 = Image.createImage((String)"/bg.png");
            this.ofSc3 = Image.createImage((String)"/sg.png");
            this.ofSc2 = Image.createImage((int)this.ofSc3.getWidth(), (int)this.ofSc3.getHeight());
            this.ofSg2 = this.ofSc2.getGraphics();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void initSign() {
        this.tgS = -1;
        try {
            if (this.nI == null) {
                this.nI = Image.createImage((String)"/nT.png");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Thread thread = new Thread(this);
        thread.start();
    }

    public void initTitle() {
        this.tgS = 0;
        try {
            if (this.pI == null) {
                this.pI = Image.createImage((String)"/pbTitle.png");
            }
            if (this.sI == null) {
                this.sI = Image.createImage((String)"/taito.png");
            }
            if (this.gI == null) {
                this.gI = Image.createImage((String)"/startW.png");
            }
            if (this.eI == null) {
                this.eI = Image.createImage((String)"/exitW.png");
            }
            if (this.rI == null) {
                this.rI = Image.createImage((String)"/retryW.png");
            }
            if (this.tI == null) {
                this.tI = Image.createImage((String)"/titleW.png");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sFont = Font.getDefaultFont();
    }

    public void init(int n, boolean bl, boolean bl2) {
        this.iS = 0;
        this.pS = 0;
        this.lV = 0;
        this.dV = 0;
        this.eC = 0;
        this.sC = 0;
        this.bR = 0;
        this.dR = 768865;
        this.mV = 21;
        this.kF = false;
        this.dF = false;
        this.mS = 0;
        this.eB = 0;
        this.dB = 0;
        this.bobP = 0;
        this.bAnim = 0;
        this.upA = false;
        this.upB = false;
        this.aWidth = this.awaI[0].getWidth();
        if (this.pA == null) {
            this.pA = new Bobble();
        }
        Bobble.init();
        Bobble.sAID();
        this.drawBobbles(this.ofSg2, 0);
        this.gF = true;
        Thread thread = new Thread(this);
        thread.start();
    }

    private void drawBobbles(Graphics graphics, int n) {
        int n2 = 0;
        int n3 = this.sC;
        int n4 = this.bR & 0xFF;
        if (n3 >= (this.dR >> this.dV * 2 & 3) + 3 - 2) {
            if (n3 == (this.dR >> this.dV * 2 & 3) + 3 - 2) {
                if ((n4 & 3) == 3) {
                    n2 = 1;
                }
            } else if ((n4 & 1) == 1) {
                n2 = 1;
            }
            this.bR = n4 >= 240 ? 0 : ++this.bR;
        }
        graphics.drawImage(this.ofSc3, 0, 0, 0x10 | 4);
        this.upB = false;
        int n5 = 9;
        while (n5 >= 0) {
            n4 = 0;
            if (Bobble.aA[5 + 6 * n5] == -1) {
                n4 = this.aWidth / 2;
            }
            int n6 = 0;
            while (n6 < 6) {
                int n7 = n6 + 6 * n5;
                n3 = Bobble.aA[n7];
                if (n3 > 0) {
                    if ((n3 & 0x10) == 16) {
                        if (this.pS == 4) {
                            graphics.drawImage(this.bomI[(n3 &= 0xF) - 1], n6 * this.aWidth + n4 - this.aWidth / 4, n5 * this.aWidth - this.aWidth / 4, 20);
                        } else {
                            graphics.drawImage(this.awaI[(n3 &= 0xF) - 1], n6 * this.aWidth + n4, n5 * this.aWidth + this.aWidth / 2, 20);
                        }
                        Bobble.cBA(n7);
                    } else {
                        n3 &= 0xF;
                        if (this.pS == -1) {
                            if (n5 >= n) {
                                graphics.drawImage(this.awaI[7], n6 * this.aWidth + n4, n5 * this.aWidth, 20);
                            } else {
                                graphics.drawImage(this.awaI[n3 - 1], n6 * this.aWidth + n4, n5 * this.aWidth, 20);
                            }
                        } else {
                            graphics.drawImage(this.awaI[n3 - 1], n6 * this.aWidth + n4, n5 * this.aWidth + n2, 20);
                            if (n5 > 5) {
                                this.upB = true;
                            }
                        }
                    }
                }
                ++n6;
            }
            --n5;
        }
        this.drawMoveBobble(graphics);
    }

    private void drawScore(Graphics graphics) {
        int n;
        int n2 = this.lV + 1;
        int n3 = this.mS;
        if (n3 > 99999) {
            n3 = 99999;
        }
        if (this.mS > this.mH) {
            this.mH = this.mS;
        }
        if ((n = this.mH) > 99999) {
            n = 99999;
        }
        try {
            char[] cArray = Integer.toString(n2).toCharArray();
            int n4 = cArray.length;
            int n5 = 0;
            while (n5 < n4) {
                graphics.drawImage(this.numI[Character.digit(cArray[n5], 10)], 132 + (5 - (n4 - n5)) * 8, 36, 0x10 | 4);
                ++n5;
            }
            cArray = Integer.toString(n3).toCharArray();
            n4 = cArray.length;
            int n6 = 0;
            while (n6 < n4) {
                graphics.drawImage(this.numI[Character.digit(cArray[n6], 10)], 132 + (5 - (n4 - n6)) * 8, 84, 0x10 | 4);
                ++n6;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void drawGameOver(Graphics graphics) {
        graphics.setFont(this.sFont);
        int n = this.sFont.getHeight();
        graphics.setColor(0xFFFFFF);
        graphics.drawString("G A M E", (96 - this.sFont.stringWidth("G A M E")) / 2 + 4, 32, 0x10 | 4);
        graphics.drawString("O V E R", (96 - this.sFont.stringWidth("O V E R")) / 2 + 4, 34 + n, 0x10 | 4);
    }

    public void drawMoveBobble(Graphics graphics) {
        int n = Bobble.aN - 1;
        graphics.drawImage(this.awaI[n], this.ofSc2.getWidth() - this.aWidth, this.ofSc2.getHeight() - this.aWidth, 0x10 | 4);
        if (this.pS >= 0) {
            graphics.drawImage(this.plyI[this.bobP], 0, this.ofSc2.getHeight() - this.plyI[this.bobP].getHeight(), 20);
            if (this.bobP > 0) {
                this.bobP = 0;
            }
        } else {
            graphics.drawImage(this.plyI[4], 0, this.ofSc2.getHeight() - this.plyI[this.bobP].getHeight(), 20);
        }
        if (this.upA) {
            this.mV = 21;
            this.upA = false;
        }
        int n2 = 56 + Bobble.CO[this.mV] * 24 / 1000 + -8;
        int n3 = 160 + Bobble.SI[this.mV] * 24 / 1000 + -8;
        n = 56 + Bobble.CO[21 - this.mV + 21] * 16 / 1000 + -8;
        int n4 = 160 + Bobble.SI[21 - this.mV + 21] * -16 / 1000 + -8;
        graphics.setColor(255, 255, 0);
        graphics.drawLine(n2, n3, n, n4);
        graphics.drawLine(n2, n3, ARW1[this.mV][0] + -8, ARW1[this.mV][1] + -8);
        graphics.drawLine(n2, n3, ARW2[this.mV][0] + -8, ARW2[this.mV][1] + -8);
        if (this.gF && this.pS < 3) {
            n = Bobble.aM - 1;
            graphics.drawImage(this.awaI[n], Bobble.aX - this.aWidth / 2, Bobble.aY - this.aWidth / 2, 0x10 | 4);
        } else if (this.pS == 0) {
            graphics.drawImage(this.awaI[Bobble.aM - 1], Bobble.aX - this.aWidth / 2, Bobble.aY - this.aWidth / 2, 0x10 | 4);
        }
    }

    public void paint(Graphics graphics) {
        graphics.setFont(this.sFont);
        if (this.tgS == -1) {
            graphics.setColor(0);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.drawImage(this.nI, (this.getWidth() - this.nI.getWidth()) / 2, (this.getHeight() - this.nI.getHeight()) / 2, 0x10 | 4);
        } else if (this.tgS == 0) {
            int n = this.sFont.getHeight();
            graphics.setColor(0);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.drawImage(this.pI, (this.getWidth() - this.pI.getWidth()) / 2, 0, 0x10 | 4);
            graphics.drawImage(this.sI, (this.getWidth() - this.sI.getWidth()) / 2, 192, 0x20 | 4);
            graphics.drawImage(this.gI, this.getWidth() - this.eI.getWidth(), this.getHeight() - this.eI.getHeight(), 0x10 | 4);
            graphics.drawImage(this.eI, 0, this.getHeight() - this.eI.getHeight(), 0x10 | 4);
            graphics.setColor(0xFFFFFF);
            graphics.drawString("PRESS START", (this.getWidth() - this.sFont.stringWidth("PRESS START")) / 2, 124, 0x10 | 4);
        } else {
            if (this.pS == 0 || this.resumeFlag) {
                graphics.setColor(0);
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (this.pS == 0 || this.resumeFlag) {
                graphics.drawImage(this.ofSc1, 0, 0, 0x10 | 4);
                graphics.drawImage(this.tI, this.getWidth() - this.tI.getWidth(), this.getHeight() - this.tI.getHeight(), 0x10 | 4);
                if (this.pS == 0) {
                    this.pS = 1;
                }
                this.resumeFlag = false;
            }
            if (this.pS < 0) {
                graphics.drawImage(this.rI, 0, this.getHeight() - this.rI.getHeight(), 0x10 | 4);
            }
            graphics.drawImage(this.ofSc2, 16, 16, 0x10 | 4);
            this.drawScore(graphics);
        }
    }

    public void run() {
        int n = 0;
        int n2 = 0;
        if (this.tgS == -1) {
            try {
                Thread.sleep(3000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.initTitle();
            this.repaint();
        }
        while (this.gF) {
            int n3;
            try {
                if (this.pS == 4) {
                    Thread.sleep(100L);
                } else if (this.pS == 5) {
                    Thread.sleep(200L);
                } else {
                    Thread.sleep(10L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.pS == 2) {
                n3 = 0;
                while (n3 < 8) {
                    int n4 = Bobble.move();
                    if (n4 < 2) {
                        if (n4 == 0) {
                            this.pS = 3;
                        }
                        break;
                    }
                    ++n3;
                }
            } else if (this.pS == 3) {
                n = Bobble.bom();
                if (n > 0) {
                    this.eB += n;
                    this.eC += n;
                    this.mS += n * 10;
                    this.pS = 4;
                    if (this.sD[2] != null) {
                        if (this.sD[2].getState() == 0) {
                            this.sD[2].stop();
                        }
                        this.sD[2].play(1);
                    }
                } else {
                    this.pS = 5;
                }
            } else if (this.pS == 4) {
                n = Bobble.drp();
                if (n > 0) {
                    this.dB += n;
                    this.eC += n;
                    if (n > 12) {
                        n = 12;
                    }
                    this.mS += 20 << n - 1;
                }
                this.pS = 5;
            } else if (this.pS == 5) {
                if (this.sC >= (this.dR >> this.dV * 2 & 3) + 3) {
                    this.sC = 0;
                    Bobble.dtR(this.dV);
                }
                if (Bobble.nA == 0) {
                    this.mS += 5000 * (this.lV + 1);
                }
                if (this.eC >= 47 && this.sC == 0) {
                    ++this.lV;
                    ++this.dV;
                    if (this.dV > 9) {
                        this.dV = this.lV - this.lV / 10 * 10;
                        if (this.lV % 10 == 0) {
                            // empty if block
                        }
                    }
                    this.eC -= 47;
                }
                this.pS = 6;
            } else if (this.pS == 6) {
                n3 = 59;
                while (n3 >= 54) {
                    if (Bobble.aA[n3] > 0) {
                        this.gF = false;
                    }
                    --n3;
                }
                Bobble.sAID();
                this.pS = 1;
            }
            if (this.pS > 0) {
                this.drawBobbles(this.ofSg2, 0);
                this.repaint();
                this.serviceRepaints();
            }
            if (this.bAnim >= 10) {
                this.resumeFlag = true;
                if (this.upB) {
                    this.bobP = 3;
                    if (this.bAnim == 20) {
                        this.bAnim = 0;
                        continue;
                    }
                    ++this.bAnim;
                    continue;
                }
                if (n2 == 1) {
                    n2 = 2;
                    this.bobP = 2;
                    this.bAnim = 0;
                    continue;
                }
                if (n2 == 2) {
                    if (this.bAnim == 20) {
                        n2 = 0;
                        this.bAnim = 0;
                        continue;
                    }
                    this.bobP = 2;
                    ++this.bAnim;
                    continue;
                }
                n2 = 1;
                this.bobP = 1;
                this.bAnim = 0;
                continue;
            }
            ++this.bAnim;
            if (n2 != 2) continue;
            this.bobP = 2;
        }
        if (this.tgS == 1) {
            this.pS = -1;
            if (!this.dF) {
                int n5 = 8;
                while (n5 >= 0) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.drawBobbles(this.ofSg2, n5);
                    if (n5 == 0) {
                        this.drawGameOver(this.ofSg2);
                    }
                    this.repaint();
                    this.serviceRepaints();
                    --n5;
                }
            }
            this.pS = -2;
        }
        System.out.println("bye");
    }

    protected void keyPressed(int n) {
        int n2 = 0;
        int n3 = n;
        try {
            n2 = this.getGameAction(n3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.tgS == 0) {
            if (n3 == -6) {
                this.owM.exitApp();
            } else if (n3 == 49 || n2 == 8 || n3 == -7) {
                this.init(0, false, false);
                this.tgS = 1;
                this.repaint();
            }
        } else if (this.tgS == 1) {
            if (this.pS == -2 && n3 == -6) {
                this.retryPlease();
            }
            if (n3 == 50 || n3 == -1) {
                if (this.gF) {
                    GameCanvas gameCanvas = this;
                    synchronized (gameCanvas) {
                        this.upA = true;
                    }
                }
            } else if (n3 == 52 || n3 == 54 || n3 == -3 || n3 == -4) {
                if (this.gF) {
                    if ((n3 == 52 || n3 == -3) && this.mV > 0) {
                        --this.mV;
                    } else if ((n3 == 54 || n3 == -4) && this.mV < 42) {
                        ++this.mV;
                    }
                }
            } else if (n3 == 53 || n2 == 8) {
                if (this.gF && this.pS == 1) {
                    System.gc();
                    this.kF = false;
                    GameCanvas gameCanvas = this;
                    synchronized (gameCanvas) {
                        this.pS = 2;
                    }
                    Bobble.mD = this.mV;
                    ++this.sC;
                }
            } else if (n3 == -7) {
                if (this.pS == -2) {
                    this.initTitle();
                    this.tgS = 0;
                    this.repaint();
                } else {
                    this.dF = true;
                    this.gF = false;
                    while (this.pS != -2) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.initTitle();
                    this.tgS = 0;
                    this.repaint();
                }
            }
        }
    }

    protected void keyReleased(int n) {
        int n2 = 0;
        int n3 = n;
        try {
            n2 = this.getGameAction(n3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void keyRepeated(int n) {
        int n2 = 0;
        int n3 = n;
        try {
            n2 = this.getGameAction(n3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void resumeMe() {
    }

    public void killMe() {
        this.dF = true;
        this.gF = false;
    }

    public void retryPlease() {
        this.init(this.mH, this.bF, this.sF);
        this.repaint();
    }

    public void resumePlease() {
        if (this.tgS == 1) {
            this.resumeFlag = true;
            if (this.pS < 0) {
                this.drawBobbles(this.ofSg2, 0);
                this.drawGameOver(this.ofSg2);
            }
            this.repaint();
            this.serviceRepaints();
        } else {
            this.repaint();
        }
    }

    public void setGConf(int n, boolean bl, boolean bl2) {
    }

    static {
        ARW1 = new int[][]{{42, 157}, {42, 156}, {42, 155}, {43, 154}, {44, 154}, {44, 152}, {45, 152}, {45, 151}, {46, 150}, {47, 150}, {47, 149}, {48, 148}, {49, 148}, {50, 147}, {51, 146}, {52, 146}, {53, 145}, {54, 145}, {55, 145}, {56, 146}, {57, 146}, {58, 145}, {59, 146}, {60, 146}, {61, 146}, {62, 147}, {62, 147}, {63, 148}, {64, 148}, {65, 149}, {66, 150}, {67, 150}, {67, 151}, {67, 152}, {68, 153}, {69, 154}, {69, 155}, {70, 155}, {70, 157}, {71, 158}, {71, 159}, {70, 160}, {70, 161}};
        ARW2 = new int[][]{{42, 161}, {42, 160}, {41, 159}, {41, 158}, {42, 157}, {42, 155}, {43, 155}, {43, 154}, {44, 153}, {45, 152}, {45, 151}, {45, 150}, {46, 150}, {47, 149}, {48, 148}, {49, 148}, {50, 147}, {50, 147}, {51, 146}, {52, 146}, {53, 146}, {54, 145}, {55, 146}, {56, 146}, {57, 145}, {58, 145}, {59, 145}, {60, 146}, {61, 146}, {62, 147}, {63, 148}, {64, 148}, {65, 149}, {65, 150}, {66, 150}, {67, 151}, {67, 152}, {68, 152}, {68, 154}, {69, 154}, {70, 155}, {70, 156}, {70, 157}};
    }
}

