/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import com.nokia.mid.ui.FullCanvas;
import java.util.Random;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameCanvas
extends FullCanvas
implements Runnable {
    private final long MIN_MEMORY;
    private final int NUM_ARROWS;
    private final int NUM_SHARKS;
    private final int NUM_BLOOD;
    private final int SHARKS_TO_NEW_STAR;
    private int eecounter1;
    private int eecounter2;
    private int eecounter3;
    private boolean showArrows;
    int screenWidth;
    int screenHeight;
    int width;
    int height;
    int moveRight;
    int moveDown;
    int lowHeight;
    int scoreHeight;
    int upperHeight;
    int x;
    int y;
    int backCounter;
    int gorgyLow;
    int catchX;
    int catchY;
    int dX;
    int dY;
    int expX;
    int expY;
    int diam = 16;
    int step = 5;
    int level;
    int stage;
    int score;
    boolean end;
    boolean firstTime;
    int oneAfterAnother;
    int missed;
    int bonusCounter;
    boolean newStar;
    boolean gameWon;
    boolean gameLost;
    int stars;
    int numArrows;
    int numSharks;
    private long repaintCounter;
    private int repaintDelay;
    private boolean firstPaint;
    private int skyX1;
    private int skyX2;
    private boolean moveLeft;
    private Image backImg;
    private Image backOverImg;
    private Image[] wavesImg;
    private int waveCounter;
    private int paintCounter;
    boolean sound;
    boolean bPlayShot;
    boolean bPlayMissed;
    boolean bPlayNew;
    Alert newStageAlert;
    Alert gameOverAlert;
    private String resultStr;
    Image[] blueShark;
    Image[] whiteShark;
    Image[] dolphin;
    Image[] bloodImg;
    SharksLocation[] locations;
    SoundsEngine soundsEngine;
    SharksEngine sharksEngine;
    WhiteSharkEngine whiteSharkEngine;
    int[][] bloodArray = new int[22][2];
    int bloodCounter;
    int bloodStep = 8;
    private Thread t;
    boolean goOn;
    boolean goWait;
    private int delay;
    boolean showWhiteShark;
    Font myFont;
    SharksHunting midlet;
    Random random = new Random();
    DirectGraphics dg;

    GameCanvas(SharksHunting sharksHunting) {
        this.MIN_MEMORY = 300000L;
        this.NUM_ARROWS = 200;
        this.NUM_SHARKS = 100;
        this.NUM_BLOOD = 22;
        this.SHARKS_TO_NEW_STAR = 50;
        this.midlet = sharksHunting;
        this.backImg = this.midlet.backImg;
        this.blueShark = this.midlet.blueShark;
        this.whiteShark = this.midlet.whiteShark;
        this.dolphin = this.midlet.dolphin;
        this.bloodImg = this.midlet.bloodImg;
        this.wavesImg = this.midlet.wavesImg;
        this.newStageAlert = new Alert("Well done!", this.resultStr, this.midlet.icon, null);
        this.gameOverAlert = new Alert("Game over", this.resultStr, this.midlet.icon, null);
        this.myFont = Font.getFont((int)0, (int)1, (int)8);
        this.screenWidth = this.getWidth();
        this.height = this.screenHeight = this.getHeight();
        this.width = this.screenWidth;
        this.moveRight = 0;
        this.moveDown = this.wavesImg[0].getHeight();
        if (SharksHunting.DEBUG) {
            System.out.println("moveDown = " + this.moveDown);
        }
        this.scoreHeight = this.myFont.getHeight() + 4;
        if (SharksHunting.DEBUG) {
            System.out.println("scoreHeight = " + this.scoreHeight);
        }
        this.lowHeight = this.height - this.scoreHeight;
        this.sharksEngine = new SharksEngine(this);
        this.soundsEngine = new SoundsEngine();
        this.locations = null;
        this.whiteSharkEngine = new WhiteSharkEngine(this);
        this.sound = true;
        this.firstPaint = true;
        this.delay = 0;
    }

    public void init() {
        this.end = false;
        this.stage = 1;
        this.stars = 3;
        this.score = 0;
        this.numArrows = 200;
        this.gameWon = false;
        this.gameLost = false;
        this.newStar = false;
        this.resultStr = "";
        this.showWhiteShark = false;
        this.showArrows = false;
        this.skyX1 = 0;
        this.skyX2 = this.screenWidth;
        this.moveLeft = true;
        this.waveCounter = 0;
        this.paintCounter = 0;
        this.catchX = this.moveRight + this.width / 2 - this.diam / 2;
        this.catchY = this.moveDown + this.height / 2 - this.diam / 2;
        this.dY = 0;
        this.dX = 0;
        this.repaintDelay = 3;
        this.repaintCounter = 0L;
        this.sharksEngine.init();
        int n = 0;
        while (n < 22) {
            this.bloodArray[n][0] = -100;
            this.bloodArray[n][1] = 0;
            ++n;
        }
        this.bloodCounter = 0;
        this.bPlayShot = false;
        this.bPlayMissed = false;
        this.bPlayNew = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (true) {
                if (!this.goOn) {
                    return;
                }
                if (this.goWait) {
                    try {
                        GameCanvas gameCanvas = this;
                        synchronized (gameCanvas) {
                            this.wait();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.checkIfGameIsOver();
                ++this.repaintCounter;
                if (this.repaintCounter >= (long)this.repaintDelay) {
                    this.repaintCounter = 0L;
                    this.moveBackground();
                    this.sharksEngine.tick();
                    if (this.showWhiteShark) {
                        this.whiteSharkEngine.tick();
                    }
                }
                this.repaint();
                this.serviceRepaints();
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            if (!SharksHunting.DEBUG) return;
            System.out.println("exception in run");
        }
    }

    void addBlood(int n) {
        boolean bl = false;
        int n2 = 0;
        try {
            n2 = 0;
            while (n2 < 22) {
                switch (n2) {
                    case 0: {
                        if (this.bloodArray[n2][0] != -100 || n >= this.bloodStep) break;
                        this.bloodArray[n2][0] = n;
                        this.bloodArray[n2][1] = Math.abs(this.random.nextInt() % 3);
                        bl = true;
                        break;
                    }
                    case 21: {
                        if (this.bloodArray[n2][0] != -100 || n <= n2 * this.bloodStep) break;
                        this.bloodArray[n2][0] = n;
                        this.bloodArray[n2][1] = Math.abs(this.random.nextInt() % 3);
                        bl = true;
                        break;
                    }
                    default: {
                        if (this.bloodArray[n2][0] != -100 || n < n2 * this.bloodStep || n >= (n2 + 1) * this.bloodStep) break;
                        this.bloodArray[n2][0] = n;
                        this.bloodArray[n2][1] = Math.abs(this.random.nextInt() % 3);
                        bl = true;
                    }
                }
                if (bl) break;
                ++n2;
            }
            if (SharksHunting.DEBUG) {
                System.out.println("xx = " + n + " : i = " + n2 + " : out = " + bl);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (SharksHunting.DEBUG) {
                System.out.println("bloodArray ArrayIndexOutOfBoundsException");
            }
            arrayIndexOutOfBoundsException.printStackTrace();
        }
    }

    void moveBackground() {
        this.skyX1 = this.skyX1 < -1 * this.screenWidth ? this.skyX2 + this.screenWidth - 1 : --this.skyX1;
        this.skyX2 = this.skyX2 < -1 * this.screenWidth ? this.skyX1 + this.screenWidth : --this.skyX2;
    }

    protected void hideNotify() {
        this.pauseAnimation();
    }

    protected void showNotify() {
        this.startAnimation();
    }

    void startAnimation() {
        if (Runtime.getRuntime().freeMemory() < 300000L) {
            System.gc();
        }
        if (this.goOn) {
            this.resumeAnimation();
        } else {
            this.goOn = true;
            if (this.t == null) {
                this.t = new Thread(this);
                this.t.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resumeAnimation() {
        if (Runtime.getRuntime().freeMemory() < 300000L) {
            System.gc();
        }
        this.goWait = false;
        GameCanvas gameCanvas = this;
        synchronized (gameCanvas) {
            this.notifyAll();
        }
    }

    void stopAnimation() {
        this.goOn = false;
        this.t = null;
    }

    void pauseAnimation() {
        if (this.goOn) {
            this.goWait = true;
        }
    }

    public void paint(Graphics graphics) {
        try {
            if (this.firstPaint) {
                this.dg = DirectUtils.getDirectGraphics((Graphics)graphics);
                this.firstPaint = false;
            }
            if (this.paintCounter == 100) {
                this.paintCounter = -1;
            }
            ++this.paintCounter;
            if (this.backImg == null) {
                graphics.setColor(6600827);
                graphics.fillRect(0, 0, this.screenWidth, this.screenHeight);
            } else {
                graphics.drawImage(this.backImg, 0, 0, 4 | 0x10);
            }
            graphics.drawImage(this.wavesImg[this.waveCounter], 0, 0, 4 | 0x10);
            if (this.paintCounter % 10 == 0) {
                ++this.waveCounter;
                if (this.waveCounter == this.wavesImg.length) {
                    this.waveCounter = 0;
                }
            }
            this.locations = null;
            this.locations = this.sharksEngine.getLocations();
            int n = 0;
            n = 0;
            while (n < 22) {
                if (this.bloodArray[n][0] > -100) {
                    graphics.drawImage(this.bloodImg[this.bloodArray[n][1]], this.bloodArray[n][0], this.lowHeight, 3);
                }
                ++n;
            }
            n = 0;
            while (n < this.locations.length) {
                if (this.locations[n].state == 1) {
                    if (this.locations[n].frame % 2 == 0) {
                        graphics.drawImage(this.bloodImg[0], this.locations[n].x + this.locations[n].w / 2, this.locations[n].y + this.locations[n].h / 2, 3);
                    } else {
                        this.dg.drawImage(this.bloodImg[0], this.locations[n].x + this.locations[n].w / 2, this.locations[n].y + this.locations[n].h / 2, 3, 8192);
                    }
                }
                ++n;
            }
            n = 0;
            while (n < this.locations.length) {
                if (this.locations[n].type == 0 && this.dolphin[this.locations[n].frame] != null) {
                    if (this.locations[n].dir == 0) {
                        graphics.drawImage(this.dolphin[this.locations[n].frame], this.locations[n].x, this.locations[n].y, 20);
                    } else {
                        this.dg.drawImage(this.dolphin[this.locations[n].frame], this.locations[n].x, this.locations[n].y, 20, 8192);
                    }
                }
                ++n;
            }
            if (this.showWhiteShark && this.whiteShark[this.whiteSharkEngine.getFrame()] != null) {
                if (this.whiteSharkEngine.getDir() == -1) {
                    graphics.drawImage(this.whiteShark[this.whiteSharkEngine.getFrame()], this.whiteSharkEngine.getX(), this.whiteSharkEngine.getY(), 3);
                } else if (this.whiteSharkEngine.getDir() == 1) {
                    this.dg.drawImage(this.whiteShark[this.whiteSharkEngine.getFrame()], this.whiteSharkEngine.getX(), this.whiteSharkEngine.getY(), 3, 8192);
                }
            }
            n = 0;
            while (n < this.locations.length) {
                if (this.locations[n].type == 1 && this.blueShark[this.locations[n].frame] != null) {
                    if (this.locations[n].dir == 1) {
                        graphics.drawImage(this.blueShark[this.locations[n].frame], this.locations[n].x, this.locations[n].y, 20);
                    } else {
                        this.dg.drawImage(this.blueShark[this.locations[n].frame], this.locations[n].x, this.locations[n].y, 20, 8192);
                    }
                }
                ++n;
            }
            graphics.setColor(0, 0, 0);
            if (this.dX < 0 && this.catchX < this.moveRight) {
                this.dX = 0;
                this.catchX = this.moveRight + 1;
            }
            if (this.dX > 0 && this.catchX > this.moveRight + this.width - this.diam) {
                this.dX = 0;
                this.catchX = this.moveRight + this.width - this.diam - 1;
            }
            this.catchX += this.dX;
            if (this.dY < 0 && this.catchY < this.moveDown) {
                this.dY = 0;
                this.catchY = this.moveDown + 1;
            }
            if (this.dY > 0 && this.catchY > this.moveDown + this.lowHeight - this.diam) {
                this.dY = 0;
                this.catchY = this.moveDown + this.lowHeight - this.diam - 1;
            }
            this.catchY += this.dY;
            graphics.drawArc(this.catchX, this.catchY, this.diam, this.diam, 0, 360);
            graphics.drawArc(this.catchX + this.diam / 4, this.catchY + this.diam / 4, this.diam / 2, this.diam / 2, 0, 360);
            graphics.drawLine(this.catchX + this.diam / 2, this.catchY, this.catchX + this.diam / 2, this.catchY + this.diam / 4);
            graphics.drawLine(this.catchX + this.diam / 2, this.catchY + this.diam - this.diam / 4, this.catchX + this.diam / 2, this.catchY + this.diam);
            graphics.drawLine(this.catchX, this.catchY + this.diam / 2, this.catchX + this.diam / 4, this.catchY + this.diam / 2);
            graphics.drawLine(this.catchX + this.diam - this.diam / 4, this.catchY + this.diam / 2, this.catchX + this.diam, this.catchY + this.diam / 2);
            graphics.setFont(this.myFont);
            graphics.setColor(0, 0, 0);
            graphics.fillRect(0, this.lowHeight, this.width, this.scoreHeight);
            graphics.setColor(0x9CFFFF);
            graphics.drawString(String.valueOf(this.score), this.width / 2, this.height - 1, 0x20 | 1);
            graphics.drawImage(this.midlet.arrowImg, 2, this.screenHeight - this.scoreHeight / 2, 4 | 2);
            graphics.drawString(String.valueOf(this.numArrows), this.midlet.arrowImg.getWidth() + 4, this.height - 1, 0x20 | 4);
            if (this.showWhiteShark) {
                graphics.setColor(255, 0, 0);
                graphics.drawString(String.valueOf(this.whiteSharkEngine.hitCounter), this.width - 2, this.height - 1, 0x20 | 8);
            } else {
                int n2 = this.width - 2;
                n = 0;
                while (n < this.stars) {
                    graphics.drawImage(this.midlet.starImg, n2, this.screenHeight - this.scoreHeight / 2, 2 | 8);
                    n2 -= 6;
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("exception in paint:");
            exception.printStackTrace();
            System.out.println("\n---");
        }
    }

    protected void keyReleased(int n) {
        this.dX = 0;
        this.dY = 0;
    }

    protected void keyPressed(int n) {
        if (n == -6 || n == -7) {
            this.pauseAnimation();
            this.midlet.currentDisplayable = this.midlet.mainList;
            this.midlet.display.setCurrent(this.midlet.currentDisplayable);
        } else if (this.getGameAction(n) == 5) {
            this.dX = this.step;
        } else if (this.getGameAction(n) == 2) {
            this.dX = -1 * this.step;
        } else if (this.getGameAction(n) == 1) {
            this.dY = -1 * this.step;
        } else if (this.getGameAction(n) == 6) {
            this.dY = this.step;
        } else if (n == 49) {
            this.dY = -1 * this.step;
            this.dX = -1 * this.step;
        } else if (n == 51) {
            this.dY = -1 * this.step;
            this.dX = this.step;
        } else if (n == 55) {
            this.dY = this.step;
            this.dX = -1 * this.step;
        } else if (n == 57) {
            this.dY = this.step;
            this.dX = this.step;
        } else if (this.getGameAction(n) == 8) {
            if (this.sound) {
                this.soundsEngine.playShot();
            }
            --this.numArrows;
            this.sharksEngine.check(this.catchX, this.catchY, this.diam);
            if (this.showWhiteShark) {
                this.whiteSharkEngine.check(this.catchX, this.catchY, this.diam);
            }
        } else if (n == 48) {
            ++this.eecounter1;
            if (this.eecounter1 > 4) {
                this.eecounter1 = 0;
                this.newStar = true;
            }
        } else if (n == 42) {
            if (this.showWhiteShark) {
                ++this.eecounter2;
                if (this.eecounter2 > 4) {
                    this.eecounter2 = 0;
                    this.gameWon = true;
                }
            }
        } else if (n == 35) {
            ++this.eecounter3;
            if (this.eecounter3 > 4) {
                this.eecounter3 = 0;
            }
        }
    }

    void playSomething() {
        switch (this.eecounter3) {
            case 0: {
                AlertType.INFO.playSound(this.midlet.display);
                break;
            }
            case 1: {
                AlertType.ERROR.playSound(this.midlet.display);
                break;
            }
            case 2: {
                AlertType.ALARM.playSound(this.midlet.display);
                break;
            }
            case 3: {
                AlertType.CONFIRMATION.playSound(this.midlet.display);
                break;
            }
            case 4: {
                AlertType.WARNING.playSound(this.midlet.display);
            }
        }
    }

    void setScore(int n) {
        if (n < 0) {
            --this.stars;
            if (this.sound) {
                this.soundsEngine.playMissedLife();
            }
            this.oneAfterAnother = 0;
        } else if (n == 0) {
            this.oneAfterAnother = 0;
        } else {
            this.score += n;
            if (n == 10) {
                ++this.numSharks;
                ++this.oneAfterAnother;
                if (this.oneAfterAnother > 0) {
                    if (this.oneAfterAnother % 10 == 0) {
                        this.score += 50;
                    }
                    if (this.oneAfterAnother % 50 == 0) {
                        this.newStar = true;
                    }
                }
            }
        }
    }

    private void checkIfGameIsOver() {
        if (this.stars <= 0 || this.numArrows <= 0) {
            this.stopAnimation();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Sorry... You lost...\n");
            if (this.stars < 1) {
                stringBuffer.append("You have no more certification stars...");
            } else {
                stringBuffer.append("You have no more arrows...");
            }
            stringBuffer.append("\nYou shot ");
            stringBuffer.append(String.valueOf(this.numSharks));
            stringBuffer.append(" sharks and your score is ");
            stringBuffer.append(String.valueOf(this.score));
            stringBuffer.append("!");
            this.midlet.currentDisplayable = this.score > 0 && this.midlet.isHighScore(this.score) ? this.midlet.getEnterNameForm(new ScoreItem(this.score, false, false)) : this.midlet.mainList;
            this.resultStr = stringBuffer.toString();
            this.gameOverAlert.setString(this.resultStr);
            this.gameOverAlert.setTimeout(-2);
            if (this.sound) {
                this.soundsEngine.playNewLife();
            }
            this.midlet.mainList.delete(0);
            this.midlet.display.setCurrent(this.gameOverAlert, this.midlet.currentDisplayable);
        } else if (this.gameWon) {
            this.stopAnimation();
            this.resultStr = "You are the best!!! \nYou have just killed the dangerous white shark and became a Jacado Senior Certified Hunter!";
            this.gameOverAlert.setString(this.resultStr);
            this.gameOverAlert.setTimeout(-2);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("In addition to the white shark you shot ");
            stringBuffer.append(String.valueOf(this.numSharks));
            stringBuffer.append(" sharks and your score is ");
            stringBuffer.append(String.valueOf(this.score));
            stringBuffer.append("!");
            this.midlet.currentDisplayable = this.midlet.getCertSeniorCanvas(stringBuffer.toString());
            this.midlet.nextDisplayable = this.score > 0 && this.midlet.isHighScore(this.score) ? this.midlet.getEnterNameForm(new ScoreItem(this.score, true, true)) : this.midlet.mainList;
            this.midlet.mainList.delete(0);
            if (this.sound) {
                this.soundsEngine.playNewLife();
            }
            this.midlet.display.setCurrent(this.gameOverAlert, this.midlet.currentDisplayable);
        } else if (this.gameLost) {
            this.stopAnimation();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Sorry, you lost... \nThe white shark has just succeeded to escape.\n");
            stringBuffer.append("You shot ");
            stringBuffer.append(String.valueOf(this.numSharks));
            stringBuffer.append(" blue sharks and your score is ");
            stringBuffer.append(String.valueOf(this.score));
            stringBuffer.append("!");
            this.midlet.currentDisplayable = this.score > 0 && this.midlet.isHighScore(this.score) ? this.midlet.getEnterNameForm(new ScoreItem(this.score, true, false)) : this.midlet.mainList;
            this.resultStr = stringBuffer.toString();
            this.gameOverAlert.setString(this.resultStr);
            this.gameOverAlert.setTimeout(-2);
            this.midlet.mainList.delete(0);
            if (this.sound) {
                this.soundsEngine.playNewLife();
            }
            this.midlet.display.setCurrent(this.gameOverAlert, this.midlet.currentDisplayable);
        } else if (this.newStar) {
            this.pauseAnimation();
            this.newStar = false;
            ++this.stars;
            this.sharksEngine.init();
            if (this.repaintDelay > 1) {
                --this.repaintDelay;
            }
            if (SharksHunting.DEBUG) {
                System.out.println("newStar: stars=" + this.stars + " repaintDelay=" + this.repaintDelay);
            }
            if (this.stars < 5) {
                this.resultStr = "Your shot 50 blue sharks in a row!  You get a new certification star!";
            } else if (this.stars == 5) {
                this.showWhiteShark = true;
                if (this.whiteSharkEngine == null) {
                    this.whiteSharkEngine = new WhiteSharkEngine(this);
                }
                this.whiteSharkEngine.init();
                this.midlet.currentDisplayable = this.midlet.getCertCanvas();
                this.midlet.nextDisplayable = this;
                this.resultStr = "You have 5 certification stars. You are a Jacado Certified Sharks Hunter!";
            }
            this.newStageAlert.setString(this.resultStr);
            this.newStageAlert.setTimeout(-2);
            if (this.sound) {
                this.soundsEngine.playNewLife();
            }
            this.midlet.display.setCurrent(this.newStageAlert, this.midlet.currentDisplayable);
        }
    }
}

