/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;

public class ScoreItem {
    String name;
    int score;
    boolean certified;
    boolean whiteShark;

    ScoreItem() {
        this.init();
    }

    ScoreItem(byte[] byArray) {
        this.initialize(byArray);
    }

    ScoreItem(int n, boolean bl, boolean bl2) {
        this.name = "";
        this.setScore(n);
        this.certified = bl;
        this.whiteShark = bl2;
    }

    void init() {
        this.name = "";
        this.score = 0;
        this.certified = false;
        this.whiteShark = false;
    }

    void init(ScoreItem scoreItem) {
        this.name = scoreItem.name;
        this.score = scoreItem.score;
        this.certified = scoreItem.certified;
        this.whiteShark = scoreItem.whiteShark;
    }

    String printInfo() {
        return "name = '" + this.name + "'\n" + "\nscore = " + this.score + "\nwhiteShark = " + this.whiteShark + "certified = " + this.certified;
    }

    void setName(String string) {
        this.name = string;
    }

    void setScore(int n) {
        this.score = n;
    }

    void setCertified(boolean bl) {
        this.certified = bl;
    }

    void setWhiteShark(boolean bl) {
        this.whiteShark = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            filterInputStream = new DataInputStream(byteArrayInputStream);
            this.name = ((DataInputStream)filterInputStream).readUTF();
            this.score = ((DataInputStream)filterInputStream).readInt();
            this.certified = ((DataInputStream)filterInputStream).readBoolean();
            this.whiteShark = ((DataInputStream)filterInputStream).readBoolean();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                byteArrayInputStream.close();
                filterInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytes() {
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            filterOutputStream = new DataOutputStream(byteArrayOutputStream);
            ((DataOutputStream)filterOutputStream).writeUTF(this.name);
            ((DataOutputStream)filterOutputStream).writeInt(this.score);
            ((DataOutputStream)filterOutputStream).writeBoolean(this.certified);
            ((DataOutputStream)filterOutputStream).writeBoolean(this.whiteShark);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                byteArrayOutputStream.close();
                filterOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return byArray;
    }
}

