/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.FullCanvas;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class SharksHunting
extends MIDlet
implements CommandListener {
    static boolean REAL_DEVICE = true;
    static boolean DEBUG = false;
    static StringBuffer testSB = new StringBuffer();
    Display display;
    Displayable currentDisplayable;
    Displayable nextDisplayable;
    private Alert alert;
    private Form loadingForm;
    private Thread thread;
    private Gauge gauge;
    private int gaugeCounter;
    CertCanvas certCanvas;
    CertSeniorCanvas certSeniorCanvas;
    private Alert certAlert;
    private Form helpForm;
    private Form aboutForm;
    ScoresDB scores;
    Form enterNameForm;
    private StringItem congratsItem;
    private String congratsStr;
    private TextField nameField;
    Form highScoresForm;
    int newHighScoreID;
    ScoreItem newRecord;
    private Alert clearAlert;
    private Command okCommand;
    private Command backCommand;
    private Command exitCommand;
    private Command saveCommand;
    List mainList;
    private String[] mainStr = new String[]{"New game", "High scores", "Turn sound off", "Help", "About"};
    private SplashCanvas splashCanvas;
    GameCanvas gameCanvas;
    Image certImg;
    Image certSeniorImg;
    Image backImg;
    Image backOverImg;
    Image[] wavesImg;
    Image[] blueShark;
    Image[] whiteShark;
    Image[] dolphin;
    Image[] bloodImg;
    Image starImg;
    Image arrowImg;
    Image icon;
    private int width;
    private int height;
    final String DEVICE_STR;
    final String APP_NAME;
    final String APP_SPLASH;
    final String APP_VERSION = "ver " + this.getAppProperty("MIDlet-Version");
    final String ABOUT_STR = "SharksHunting, version " + this.getAppProperty("MIDlet-Version") + "\nCopyright 2003 Zindell Technologies, Ltd. All rights reserved. Developed by " + this.getAppProperty("MIDlet-Vendor") + " " + this.getAppProperty("MIDlet-Info-URL") + "\nSoftware is provided \"AS IS\" without warranty of any kind. In no event, shall we be liable for any claim, damages or other liability.";
    final String HELP_STR;

    public SharksHunting() {
        this.DEVICE_STR = "7650";
        this.APP_NAME = "SharksHunting";
        this.APP_SPLASH = "/SharksHuntingSplash.png";
        this.HELP_STR = "Hunt the sharks and become a Jacado Certified Sharks Hunter! Use the navigation keys to move the sight of your gun. You can use '1', '3', '7' and '9' numeric keys to move diagonally. Press the fire key to shoot. When the game starts you receive 3 certification stars and 200 arrows. If you hit a blue shark you get 10 points. When you succeed to hit 10 blue sharks repeatedly, you get a bonus of 50 points. When you repeatedly hit 50 blue sharks you gain a certification star. The speed of the game increases with every new star you get. When you reach 5 stars, you become a Jacado Certified Sharks Hunter. When that happens, you get the chance to hunt the dangerous white shark. To kill the white shark you need to hit it 20 times. Be careful not to hit the dolphins. If you hit a dolphin you lose a certification star. For every dolphin you allow to get out of the screen you receive 5 points. \nFor more information please contact us at SharksHunting@jacado.com.";
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.mainList) {
            if (command == this.exitCommand) {
                this.exit();
            } else if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("New game")) {
                this.gameCanvas.init();
                this.currentDisplayable = this.gameCanvas;
                this.display.setCurrent(this.currentDisplayable);
                if (this.mainList.size() == this.mainStr.length) {
                    this.mainList.insert(0, "Continue", null);
                }
            } else if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("Continue")) {
                this.currentDisplayable = this.gameCanvas;
                this.display.setCurrent(this.currentDisplayable);
            } else if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("High scores")) {
                this.currentDisplayable = this.getHighScoresForm();
                this.display.setCurrent(this.currentDisplayable);
            } else if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("Turn sound off")) {
                this.gameCanvas.sound = false;
                if (this.mainList.size() == this.mainStr.length) {
                    this.mainList.set(2, "Turn sound on", null);
                } else {
                    this.mainList.set(3, "Turn sound on", null);
                }
                this.currentDisplayable = this.mainList;
                this.display.setCurrent(this.currentDisplayable);
            } else if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("Turn sound on")) {
                this.gameCanvas.sound = true;
                if (this.mainList.size() == this.mainStr.length) {
                    this.mainList.set(2, "Turn sound off", null);
                } else {
                    this.mainList.set(3, "Turn sound off", null);
                }
                this.currentDisplayable = this.mainList;
                this.display.setCurrent(this.currentDisplayable);
            } else if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("Help")) {
                this.currentDisplayable = this.getHelpForm();
                if (DEBUG) {
                    System.out.println("currentDisplayable = " + this.currentDisplayable);
                }
                this.display.setCurrent(this.currentDisplayable);
            } else if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("About")) {
                this.currentDisplayable = this.getAboutForm();
                this.display.setCurrent(this.currentDisplayable);
            }
        } else if (displayable == this.highScoresForm) {
            this.currentDisplayable = this.mainList;
            this.display.setCurrent(this.currentDisplayable);
        } else if (displayable == this.enterNameForm) {
            this.newRecord.setName(this.nameField.getString());
            try {
                this.scores = new ScoresDB("scores.db");
                this.scores.insertScore(this.newHighScoreID, this.newRecord);
                this.scores.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.currentDisplayable = this.mainList;
            this.display.setCurrent(this.currentDisplayable);
        } else {
            this.currentDisplayable = this.mainList;
            this.display.setCurrent(this.currentDisplayable);
        }
    }

    public void startApp() {
        if (this.display == null) {
            this.display = Display.getDisplay((MIDlet)this);
            this.loadingForm = new Form("Loading...");
            this.currentDisplayable = this.loadingForm;
            this.gauge = new Gauge("Please wait", false, 9, 0);
            this.loadingForm.append((Item)this.gauge);
            this.gaugeCounter = 0;
            this.gauge.setValue(this.gaugeCounter);
            this.display.setCurrent((Displayable)this.loadingForm);
            this.thread = new Thread(){

                public void run() {
                    try {
                        SharksHunting.this.okCommand = new Command("OK", 4, 4);
                        SharksHunting.this.backCommand = new Command("Back", 2, 2);
                        SharksHunting.this.exitCommand = new Command("Exit", 7, 5);
                        SharksHunting.this.saveCommand = new Command("Save", 4, 4);
                        SharksHunting.this.gauge.setValue(++SharksHunting.this.gaugeCounter);
                        SharksHunting.this.backImg = Image.createImage((String)"/SharksHunting_7650_back.png");
                        SharksHunting.this.starImg = Image.createImage((String)"/star.png");
                        SharksHunting.this.arrowImg = Image.createImage((String)"/arrow.png");
                        SharksHunting.this.icon = Image.createImage((String)"/SharksHunting_7650_icon.png");
                        SharksHunting.this.gauge.setValue(++SharksHunting.this.gaugeCounter);
                        if (DEBUG) {
                            System.out.println("back images loaded");
                        }
                        SharksHunting.this.wavesImg = new Image[5];
                        int n = 0;
                        while (n < SharksHunting.this.wavesImg.length) {
                            SharksHunting.this.wavesImg[n] = Image.createImage((String)("/waves/Layer_" + (n + 1) + ".png"));
                            ++n;
                        }
                        SharksHunting.this.gauge.setValue(++SharksHunting.this.gaugeCounter);
                        SharksHunting.this.blueShark = new Image[5];
                        int n2 = 0;
                        while (n2 < SharksHunting.this.blueShark.length) {
                            SharksHunting.this.blueShark[n2] = Image.createImage((String)("/blueShark/blueShark_" + (n2 + 1) + ".png"));
                            ++n2;
                        }
                        SharksHunting.this.gauge.setValue(++SharksHunting.this.gaugeCounter);
                        SharksHunting.this.dolphin = new Image[5];
                        int n3 = 0;
                        while (n3 < SharksHunting.this.dolphin.length) {
                            SharksHunting.this.dolphin[n3] = Image.createImage((String)("/dolphin/dolphin_" + (n3 + 1) + ".png"));
                            ++n3;
                        }
                        SharksHunting.this.gauge.setValue(++SharksHunting.this.gaugeCounter);
                        SharksHunting.this.whiteShark = new Image[8];
                        int n4 = 0;
                        while (n4 < SharksHunting.this.whiteShark.length) {
                            SharksHunting.this.whiteShark[n4] = Image.createImage((String)("/whiteShark/whiteShark_" + (n4 + 1) + ".png"));
                            ++n4;
                        }
                        SharksHunting.this.gauge.setValue(++SharksHunting.this.gaugeCounter);
                        SharksHunting.this.bloodImg = new Image[3];
                        int n5 = 0;
                        while (n5 < SharksHunting.this.bloodImg.length) {
                            SharksHunting.this.bloodImg[n5] = Image.createImage((String)("/blood/blood_" + n5 + ".png"));
                            ++n5;
                        }
                        SharksHunting.this.gauge.setValue(++SharksHunting.this.gaugeCounter);
                        SharksHunting.this.mainList = new List("SharksHunting", 3, SharksHunting.this.mainStr, null);
                        SharksHunting.this.mainList.addCommand(SharksHunting.this.exitCommand);
                        SharksHunting.this.mainList.setCommandListener((CommandListener)SharksHunting.this);
                        SharksHunting.this.gauge.setValue(++SharksHunting.this.gaugeCounter);
                        SharksHunting.this.gameCanvas = new GameCanvas(SharksHunting.this);
                        SharksHunting.this.gauge.setValue(++SharksHunting.this.gaugeCounter);
                        SharksHunting.this.currentDisplayable = SharksHunting.this.mainList;
                        SharksHunting.this.splashCanvas = new SplashCanvas(SharksHunting.this.currentDisplayable);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            };
            this.thread.start();
        } else {
            this.display.setCurrent(this.currentDisplayable);
        }
    }

    boolean isHighScore(int n) {
        try {
            this.scores = new ScoresDB("scores.db");
            this.newHighScoreID = this.scores.isHighScore(n);
            this.scores.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.newHighScoreID >= 0;
    }

    Form getEnterNameForm(ScoreItem scoreItem) {
        if (this.enterNameForm == null) {
            this.enterNameForm = new Form("Well done!");
            this.enterNameForm.addCommand(this.okCommand);
            this.enterNameForm.setCommandListener((CommandListener)this);
            this.congratsStr = "You are in our Top Five list!";
            this.nameField = new TextField("Your name", null, 20, 0);
            this.enterNameForm.append(this.congratsStr);
            this.enterNameForm.append((Item)this.nameField);
        }
        this.newRecord = scoreItem;
        this.nameField.setString("");
        return this.enterNameForm;
    }

    Form getHighScoresForm() {
        if (this.highScoresForm == null) {
            this.highScoresForm = new Form("Top five");
            this.highScoresForm.addCommand(this.backCommand);
            this.highScoresForm.setCommandListener((CommandListener)this);
            if (DEBUG) {
                System.out.println("highScoresForm created");
            }
        }
        if (this.highScoresForm.size() > 0) {
            this.highScoresForm.delete(0);
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            this.scores = new ScoresDB("scores.db");
            if (this.scores.isEmpty()) {
                stringBuffer.append("No scores yet.");
            } else {
                int n = 0;
                while (n < 5) {
                    if (this.scores.getHighScores()[n].score > 0) {
                        stringBuffer.append(String.valueOf(n + 1));
                        stringBuffer.append(") ");
                        stringBuffer.append(String.valueOf(this.scores.getHighScores()[n].score));
                        stringBuffer.append(" points");
                        if (!this.scores.getHighScores()[n].name.trim().equals("")) {
                            stringBuffer.append(" - ");
                            stringBuffer.append(this.scores.getHighScores()[n].name);
                        }
                        if (this.scores.getHighScores()[n].certified) {
                            stringBuffer.append(" (");
                            if (this.scores.getHighScores()[n].whiteShark) {
                                stringBuffer.append("Senior ");
                            }
                            stringBuffer.append("Certified Hunter)");
                        }
                        stringBuffer.append("\n\n");
                    }
                    ++n;
                }
            }
            this.scores.close();
            if (DEBUG) {
                System.out.println("scores closed");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.highScoresForm.append(stringBuffer.toString());
        return this.highScoresForm;
    }

    Form getHelpForm() {
        if (this.helpForm == null) {
            this.helpForm = new Form("Help");
            this.helpForm.append("Hunt the sharks and become a Jacado Certified Sharks Hunter! Use the navigation keys to move the sight of your gun. You can use '1', '3', '7' and '9' numeric keys to move diagonally. Press the fire key to shoot. When the game starts you receive 3 certification stars and 200 arrows. If you hit a blue shark you get 10 points. When you succeed to hit 10 blue sharks repeatedly, you get a bonus of 50 points. When you repeatedly hit 50 blue sharks you gain a certification star. The speed of the game increases with every new star you get. When you reach 5 stars, you become a Jacado Certified Sharks Hunter. When that happens, you get the chance to hunt the dangerous white shark. To kill the white shark you need to hit it 20 times. Be careful not to hit the dolphins. If you hit a dolphin you lose a certification star. For every dolphin you allow to get out of the screen you receive 5 points. \nFor more information please contact us at SharksHunting@jacado.com.");
            this.helpForm.addCommand(this.backCommand);
            if (DEBUG) {
                System.out.println("helpForm : okCommand added");
            }
            this.helpForm.setCommandListener((CommandListener)this);
            if (DEBUG) {
                System.out.println("helpForm created");
            }
        }
        return this.helpForm;
    }

    Form getAboutForm() {
        if (this.aboutForm == null) {
            this.aboutForm = new Form("About");
            this.aboutForm.append(this.ABOUT_STR);
            this.aboutForm.addCommand(this.backCommand);
            this.aboutForm.setCommandListener((CommandListener)this);
        }
        return this.aboutForm;
    }

    CertCanvas getCertCanvas() {
        if (this.certCanvas == null) {
            this.certCanvas = new CertCanvas();
        }
        this.certAlert = null;
        this.certAlert = new Alert("Well done!", "The blood on the bottom is very attractive to the white shark! Now you can kill it!", this.blueShark[3], null);
        this.certAlert.setTimeout(-2);
        if (this.gameCanvas.sound) {
            this.certAlert.setType(AlertType.INFO);
        }
        return this.certCanvas;
    }

    CertSeniorCanvas getCertSeniorCanvas(String string) {
        if (this.certSeniorCanvas == null) {
            this.certSeniorCanvas = new CertSeniorCanvas();
        }
        this.certAlert = null;
        this.certAlert = new Alert("Well done!", string, this.blueShark[3], null);
        this.certAlert.setTimeout(-2);
        if (this.gameCanvas.sound) {
            this.certAlert.setType(AlertType.INFO);
        }
        return this.certSeniorCanvas;
    }

    public void exit() {
        this.notifyDestroyed();
        try {
            this.destroyApp(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pauseApp() {
        if (this.currentDisplayable != this.mainList) {
            this.currentDisplayable = this.display.getCurrent();
        }
    }

    public void destroyApp(boolean bl) {
        this.display = null;
        this.currentDisplayable = null;
        this.mainList = null;
        this.loadingForm = null;
        this.helpForm = null;
        this.aboutForm = null;
        this.okCommand = null;
        this.backCommand = null;
        this.splashCanvas = null;
        this.gauge = null;
        this.gameCanvas = null;
        this.thread = null;
    }

    private class CertSeniorCanvas
    extends FullCanvas {
        private CertSeniorCanvas() {
            try {
                SharksHunting.this.certSeniorImg = Image.createImage((String)"/certSenior.png");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        protected void paint(Graphics graphics) {
            if (SharksHunting.this.certSeniorImg != null) {
                graphics.drawImage(SharksHunting.this.certSeniorImg, 0, 0, 20);
            }
        }

        protected void keyPressed(int n) {
            this.dismiss();
        }

        protected void pointerPressed(int n, int n2) {
            this.dismiss();
        }

        private void dismiss() {
            SharksHunting.this.currentDisplayable = SharksHunting.this.nextDisplayable;
            SharksHunting.this.display.setCurrent(SharksHunting.this.certAlert, SharksHunting.this.currentDisplayable);
        }
    }

    private class CertCanvas
    extends FullCanvas {
        private CertCanvas() {
            try {
                SharksHunting.this.certImg = Image.createImage((String)"/cert.png");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        protected void paint(Graphics graphics) {
            if (SharksHunting.this.certImg != null) {
                graphics.drawImage(SharksHunting.this.certImg, 0, 0, 20);
            }
        }

        protected void keyPressed(int n) {
            this.dismiss();
        }

        protected void pointerPressed(int n, int n2) {
            this.dismiss();
        }

        private void dismiss() {
            SharksHunting.this.currentDisplayable = SharksHunting.this.nextDisplayable;
            SharksHunting.this.display.setCurrent(SharksHunting.this.certAlert, SharksHunting.this.currentDisplayable);
        }
    }

    private class SplashCanvas
    extends FullCanvas {
        private Font bigFont;
        private Font smallFont;
        private Timer timer = new Timer();
        private Image splashImg;
        private int width;
        private int height;
        private int x;
        private int y1;
        private int y2;
        private Displayable curDisplayable;

        private SplashCanvas(Displayable displayable) {
            this.bigFont = Font.getFont((int)0, (int)1, (int)0);
            this.smallFont = Font.getFont((int)0, (int)0, (int)0);
            this.curDisplayable = displayable;
            this.width = this.getWidth();
            this.height = this.getHeight();
            try {
                this.splashImg = Image.createImage((String)"/SharksHuntingSplash.png");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            SharksHunting.this.display.setCurrent((Displayable)this);
        }

        protected void showNotify() {
            this.timer.schedule((TimerTask)new CountDown(), 5000L);
        }

        protected void keyPressed(int n) {
            this.dismiss();
        }

        protected void pointerPressed(int n, int n2) {
            this.dismiss();
        }

        protected void paint(Graphics graphics) {
            if (this.splashImg == null) {
                graphics.setColor(0, 0, 180);
                graphics.fillRect(0, 0, 176, 208);
                graphics.setColor(160, 0, 0);
                graphics.setFont(this.bigFont);
                graphics.drawString("SharksHunting", this.width / 2, this.height / 2 - 10, 33);
                graphics.setFont(this.smallFont);
                graphics.drawString(SharksHunting.this.APP_VERSION, this.width / 2, this.height / 2 + 10, 17);
            } else {
                graphics.drawImage(this.splashImg, 0, 0, 20);
            }
        }

        private void dismiss() {
            this.timer.cancel();
            SharksHunting.this.display.setCurrent(this.curDisplayable);
        }

        private class CountDown
        extends TimerTask {
            private CountDown() {
            }

            public void run() {
                SplashCanvas.this.dismiss();
            }
        }
    }
}

