/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

class SharksLocation {
    static final int DOLPHIN = 0;
    static final int SHARK = 1;
    static final int ALIVE = 0;
    static final int SHOOT = 1;
    static final int FELT = 2;
    static final int REMOVED = 3;
    static final int SHARK_POINTS = 10;
    static final int DOLPHIN_POINTS = 5;
    static final int LEFT = 0;
    static final int RIGHT = 1;
    private static final int S_W = 21;
    private static final int S_H = 14;
    private static final int L_W = 30;
    private static final int L_H = 20;
    int x;
    int y;
    int w;
    int h;
    int type;
    int dir;
    int frame;
    int numFrames;
    int step;
    int upDown;
    int state;
    boolean killed;
    int lowBondary;
    int upperBondary;
    int leftBondary;
    int rightBondary;
    Random random = new Random();
    GameCanvas canvas;

    void printShark() {
        System.out.println("--- sharkLocation.printShark() ---");
        System.out.println("upDown = " + this.upDown);
        if (this.dir == 0) {
            System.out.println("dir = LEFT");
        } else {
            System.out.println("dir = RIGHT");
        }
        System.out.println("x = " + this.x);
        System.out.println("y = " + this.y);
        if (this.type == 1) {
            System.out.println("type = SHARK");
        } else {
            System.out.println("type = DOLPHIN");
        }
    }

    SharksLocation(GameCanvas gameCanvas) {
        this.canvas = gameCanvas;
        this.lowBondary = gameCanvas.lowHeight;
        this.rightBondary = gameCanvas.moveRight + gameCanvas.width;
    }

    void init() {
        this.killed = false;
        this.state = 0;
        this.frame = 0;
        this.step = Math.abs(this.random.nextInt() % 3) + 3;
        this.type = Math.abs(this.random.nextInt() % 6);
        if (this.type != 0) {
            this.type = 1;
        }
        this.numFrames = this.type == 1 ? this.canvas.blueShark.length : this.canvas.dolphin.length;
        this.dir = Math.abs(this.random.nextInt() % 2);
        this.upDown = Math.abs(this.random.nextInt() % 3) - 1;
        this.x = this.getX(this.dir);
        this.y = this.getY(this.upDown);
    }

    void randomize(SharksLocation sharksLocation) {
        int n = 0;
        if (this.dir == sharksLocation.dir) {
            while (this.upDown == sharksLocation.upDown) {
                this.upDown = Math.abs(this.random.nextInt() % 3) - 1;
                if (++n > 100) break;
            }
        }
        n = 0;
        while (this.y > sharksLocation.y - 7 && this.y < sharksLocation.y + 7) {
            this.y = this.getY(this.upDown);
            if (++n > 100) break;
        }
    }

    int getX(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = this.canvas.width + this.canvas.moveRight;
                break;
            }
            case 1: {
                n2 = this.type == 0 ? this.canvas.moveRight - this.canvas.dolphin[0].getWidth() : this.canvas.moveRight - this.canvas.blueShark[0].getWidth();
            }
        }
        return n2;
    }

    int getY(int n) {
        int n2 = 0;
        switch (n) {
            case -1: {
                n2 = Math.abs(this.random.nextInt() % (this.canvas.lowHeight / 2 - this.h)) + this.canvas.moveDown + this.canvas.lowHeight / 2;
                break;
            }
            case 0: {
                n2 = Math.abs(this.random.nextInt() % (this.canvas.lowHeight - this.h)) + this.canvas.moveDown;
                break;
            }
            case 1: {
                n2 = Math.abs(this.random.nextInt() % (this.canvas.lowHeight / 2)) + this.canvas.moveDown;
            }
        }
        return n2;
    }

    boolean ifOutOfBondaries() {
        boolean bl = false;
        if (this.type == 1) {
            this.w = this.canvas.blueShark[this.frame].getWidth();
            this.h = this.canvas.blueShark[this.frame].getHeight();
        } else {
            this.w = this.canvas.dolphin[this.frame].getWidth();
            this.h = this.canvas.dolphin[this.frame].getHeight();
        }
        this.upperBondary = this.canvas.moveDown;
        this.leftBondary = this.canvas.moveRight - this.w;
        if (this.state == 0) {
            if (this.y < this.upperBondary) {
                this.upDown = -1 * this.upDown;
            } else {
                switch (this.dir) {
                    case 0: {
                        if (this.x >= this.leftBondary && this.y <= this.lowBondary) break;
                        bl = true;
                        break;
                    }
                    case 1: {
                        if (this.x <= this.rightBondary && this.y <= this.lowBondary) break;
                        bl = true;
                    }
                }
            }
        }
        return bl;
    }

    void tick() {
        ++this.frame;
        if (this.frame >= this.numFrames) {
            this.frame = 0;
        }
        switch (this.state) {
            case 0: {
                switch (this.dir) {
                    case 0: {
                        this.x -= this.step;
                        this.y += this.upDown;
                        break;
                    }
                    case 1: {
                        this.x += this.step;
                        this.y += this.upDown;
                    }
                }
                break;
            }
            case 1: {
                if (this.y + 15 < this.lowBondary) {
                    this.y += 10;
                    break;
                }
                this.canvas.addBlood(this.x + this.w / 2);
                this.killed = true;
            }
        }
    }
}

