/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import java.io.InputStream;

class SoundsEngine {
    private Sound missedLife;
    private byte[] missedLifeBytes = new byte[50000];
    private Sound shot;
    private byte[] shotBytes;
    private Sound newLife;
    private byte[] newLifeBytes;
    private InputStream tune;
    private Sound[] sounds;

    SoundsEngine() {
        try {
            this.tune = this.getClass().getResourceAsStream("/sounds/missedLife.wav");
            this.tune.read(this.missedLifeBytes, 0, this.missedLifeBytes.length);
            this.missedLife = new Sound(this.missedLifeBytes, 5);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
            this.missedLife = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (SharksHunting.DEBUG) {
                System.out.println("missedLife exception");
            }
            this.missedLife = null;
        }
        this.shotBytes = new byte[50000];
        try {
            this.tune = this.getClass().getResourceAsStream("/sounds/shot.wav");
            this.tune.read(this.shotBytes, 0, this.shotBytes.length);
            this.shot = new Sound(this.shotBytes, 5);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
            this.shot = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (SharksHunting.DEBUG) {
                System.out.println("shot exception");
            }
            this.shot = null;
        }
        this.newLifeBytes = new byte[50000];
        try {
            this.tune = this.getClass().getResourceAsStream("/sounds/newLife.wav");
            this.tune.read(this.newLifeBytes, 0, this.newLifeBytes.length);
            this.newLife = new Sound(this.newLifeBytes, 5);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
            this.newLife = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (SharksHunting.DEBUG) {
                System.out.println("newLife exception");
            }
            this.newLife = null;
        }
        this.sounds = new Sound[3];
        this.sounds[0] = this.missedLife;
        this.sounds[1] = this.shot;
        this.sounds[2] = this.newLife;
    }

    void playShot() {
        if (this.shot != null) {
            try {
                this.stopAll();
                this.shot.init(this.shotBytes, 5);
                this.shot.play(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void playMissedLife() {
        if (this.missedLife != null) {
            try {
                this.stopAll();
                this.missedLife.init(this.missedLifeBytes, 5);
                this.missedLife.play(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void playNewLife() {
        if (this.newLife != null) {
            try {
                this.stopAll();
                this.newLife.init(this.newLifeBytes, 5);
                this.newLife.play(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void stopAll() {
        int n = 0;
        while (n < this.sounds.length) {
            if (this.sounds[n] != null && this.sounds[n].getState() == 0) {
                this.sounds[n].stop();
            }
            ++n;
        }
    }
}

