/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

class WhiteSharkEngine {
    static final int LEFT = -1;
    static final int RIGHT = 1;
    int x;
    int y;
    int frame;
    int step;
    int upDown;
    int dir;
    private boolean blowFire;
    private boolean goLeft;
    boolean killed;
    private int fireDelay;
    private int fireCounter;
    private int yCounter;
    Random random = new Random();
    GameCanvas canvas;
    int showCounter;
    int timesCounter;
    int hitCounter;

    WhiteSharkEngine(GameCanvas gameCanvas) {
        this.canvas = gameCanvas;
        this.init();
    }

    void init() {
        this.frame = 0;
        this.y = 2 * this.canvas.lowHeight / 3;
        this.dir = Math.abs(this.random.nextInt() % 2);
        if (this.dir == 0) {
            this.dir = -1;
            this.x = this.canvas.width + this.canvas.whiteShark[this.frame].getWidth() / 2;
        } else {
            this.x = this.canvas.moveRight - this.canvas.whiteShark[this.frame].getWidth() / 2;
        }
        this.killed = false;
        this.showCounter = 0;
        this.timesCounter = 0;
        this.hitCounter = 0;
    }

    int getX() {
        return this.x;
    }

    int getY() {
        return this.y;
    }

    int getFrame() {
        return this.frame;
    }

    int getDir() {
        return this.dir;
    }

    private boolean outOfBondaries() {
        return this.dir == -1 && this.x + this.canvas.whiteShark[this.frame].getWidth() / 2 < 0 || this.dir == 1 && this.x - this.canvas.whiteShark[this.frame].getWidth() / 2 > this.canvas.width;
    }

    void check(int n, int n2, int n3) {
        int n4 = this.canvas.whiteShark[this.frame].getWidth();
        int n5 = this.canvas.whiteShark[this.frame].getHeight();
        if (n > this.x - n3 && n < this.x + n4 && n2 > this.y - n3 && n2 < this.y + n5) {
            ++this.hitCounter;
            if (this.hitCounter >= 20) {
                this.killed = true;
                this.canvas.gameWon = true;
            }
        }
    }

    void tick() {
        if (!this.killed) {
            ++this.frame;
            if (this.frame >= this.canvas.whiteShark.length) {
                this.frame = 0;
            }
            this.step = Math.abs(this.random.nextInt() % 4) + 2;
            this.x += this.dir * this.step;
            this.upDown = Math.abs(this.random.nextInt() % 2) + 1;
            if (this.y > this.canvas.lowHeight) {
                this.upDown = -1 * this.upDown;
            } else if (this.y > this.canvas.lowHeight / 2 && Math.abs(this.random.nextInt() % 2) == 0) {
                this.upDown = -1 * this.upDown;
            }
            this.y += this.upDown;
            if (this.outOfBondaries()) {
                ++this.timesCounter;
                if (this.timesCounter > 3) {
                    this.canvas.gameLost = true;
                } else {
                    this.y = this.canvas.lowHeight / 2;
                    this.dir = -1 * this.dir;
                    this.x = this.dir == -1 ? this.canvas.width + this.canvas.whiteShark[this.frame].getWidth() / 2 : this.canvas.moveRight - this.canvas.whiteShark[this.frame].getWidth() / 2;
                }
            }
        }
    }
}

