/*
 * Decompiled with CFR 0.152.
 */
public class Bullet {
    public int x;
    public int y;
    public int Type;
    public Animation Picture;
    public Rect FireRect = new Rect();
    public int xspeed;
    public int yspeed;
    public static final int[] SPEEDS = new int[]{12, 6, 5};

    public Bullet(int Type, int x, int y, int xspeed, int yspeed) {
        this.Type = Type;
        this.x = x;
        this.y = y;
        this.xspeed = xspeed;
        this.yspeed = yspeed;
        this.Picture = PlatformGame.Bullet;
        if (Type == 1) {
            this.Picture = PlatformGame.GranadeBullet;
        }
    }

    public boolean Process() {
        int nextx = this.x + SPEEDS[this.Type] * this.xspeed;
        if (this.Type == 2) {
            if (this.x < nextx) {
                this.FireRect.Init(this.x, this.y, nextx - this.x, 1);
            } else {
                this.FireRect.Init(nextx, this.y, this.x - nextx, 1);
            }
            if (CollisionDetector.Check(Player.PlayerRect, this.FireRect)) {
                Player.WasHit();
                return false;
            }
            for (int i = 0; i < MapArray.ElementLng; ++i) {
                if (MapArray.ResultElements[i].Type > 0 || !CollisionDetector.Check(this.FireRect, MapArray.ResultElements[i].MapRect)) continue;
                return false;
            }
        } else {
            int nexty = this.y + SPEEDS[this.Type] * this.yspeed;
            int tempx = this.x;
            int tempy = this.y;
            for (int i = 0; i < SPEEDS[this.Type]; i += 2) {
                int j;
                tempy += this.yspeed * 2;
                if ((tempx += this.xspeed * 2) > ActiveArea.x + 176 || tempx < ActiveArea.x) {
                    return false;
                }
                this.FireRect.Init(tempx, tempy, 2, 2);
                for (j = 0; j < MapArray.EnemyLng; ++j) {
                    Enemy tempChar = MapArray.ResultEnemy[j];
                    if (!CollisionDetector.Check(tempChar.MapRect, this.FireRect) || tempChar.State == 255) continue;
                    if (this.Type == 0) {
                        tempChar.WasHit();
                    } else {
                        ActiveArea.BigBooms.addElement(new BigBoom(tempx, tempy));
                    }
                    return false;
                }
                for (j = 0; j < MapArray.ElementLng; ++j) {
                    MapElement AE = MapArray.ResultElements[j];
                    if (!CollisionDetector.Check(AE.MapRect, this.FireRect) || AE.Type == 2 || AE.Type == 3) continue;
                    if (AE.Type == 10) {
                        AE.Type = 3;
                        ActiveArea.BigBooms.addElement(new BigBoom(AE.x + (AE.width >> 1), AE.y + (AE.height >> 1)));
                    }
                    if (AE.Type == 1 || AE.Type == 6 || AE.Type == 7) continue;
                    if (AE.Type == 4 || AE.Type == 5) {
                        Bonus tmp = AE.Type == 5 ? PlatformGame.LifeIconBonus.Clone() : PlatformGame.GranadeBonus.Clone();
                        tmp.x = AE.x + 3;
                        tmp.y = AE.y;
                        tmp.BonusRect = new Rect(tmp.x, tmp.y, 8, 8);
                        MapArray.ResultBonus.addElement(tmp);
                        AE.Picture = PlatformGame.BoxBoom;
                    }
                    if (this.Type == 1) {
                        ActiveArea.BigBooms.addElement(new BigBoom(tempx, tempy));
                    }
                    return false;
                }
            }
            this.y = nexty;
        }
        this.x = nextx;
        return true;
    }

    public void Draw() {
        this.Picture.Draw(this.x - ActiveArea.x, this.y - ActiveArea.y);
    }
}

