/*
 * Decompiled with CFR 0.152.
 */
public class CollisionDetector {
    static boolean Check(Rect a, Rect b) {
        return a.right > b.left && b.right > a.left && a.top < b.bottom && b.top < a.bottom;
    }

    static Rect GetRect(Rect a, Rect b) {
        int left = a.left;
        int top = a.top;
        int right = a.right;
        int bottom = a.bottom;
        if (b.left > a.left) {
            left = b.left;
        }
        if (b.top > a.top) {
            top = b.top;
        }
        if (b.right < a.right) {
            right = b.right;
        }
        if (b.bottom < a.bottom) {
            bottom = b.bottom;
        }
        return new Rect(left, top, right - left, bottom - top);
    }

    static int GetCollisionSide(Rect a, Rect r) {
        int Side = 0;
        if (r.left == a.left) {
            Side |= 1;
        }
        if (r.right == a.right) {
            Side |= 2;
        }
        if (r.top == a.top) {
            Side |= 4;
        }
        if (r.bottom == a.bottom) {
            Side |= 8;
        }
        return Side;
    }
}

