/*
 * Decompiled with CFR 0.152.
 */
public class Enemy {
    public int x;
    public int y;
    public int width;
    public int height;
    public int Type;
    public Bullet EnemyBullet;
    public int RoundsBeforeFire = 8;
    public int FireRounds;
    public static final int[] SPIDERJUMPARRAY = new int[]{6, 6, 5, 5, 4, 4, 3, 3, 2, -2, -3, -3, -4, -4, -5, -5, -6, -6};
    public int DiePosition;
    public Rect MapRect = new Rect();
    public Animation[] Picture;
    public int[] MovingPath;
    public int Energy;
    public int State = 1;
    public int Processed;

    public void Draw() {
        if (this.State == 255) {
            return;
        }
        this.Picture[this.State].Draw(this.x - ActiveArea.x, this.y - ActiveArea.y);
    }

    public void WasHit() {
        if (this.State > 5) {
            return;
        }
        ++PlatformGame.Hit;
        if (--this.Energy == 0) {
            int n = this.Type;
            PlatformGame.EnemyDie[n] = PlatformGame.EnemyDie[n] + 1;
            if (this.Type == 3) {
                this.State = 7;
                if (this.State >= 0 && this.State <= 2) {
                    this.State = 6;
                }
                this.DiePosition = 15;
            } else if (this.Type == 4) {
                ActiveArea.BigBooms.addElement(new BigBoom(this.x + (this.width >> 1), this.y + (this.width >> 1)));
                this.State = 255;
                --PlatformGame.EnemyNumber;
            } else {
                FrashMeet t = new FrashMeet(this.x + (this.width >> 1), this.y + this.height);
                ActiveArea.FrashMeets.addElement(t);
                t.Predicator = Player.x > this.x ? -1 : 1;
                this.State = 255;
                --PlatformGame.EnemyNumber;
            }
        }
    }

    public void Process() {
        if (this.State == 255) {
            return;
        }
        if (this.State == 6 || this.State == 7) {
            if (--this.DiePosition == 0) {
                this.State = 255;
                --PlatformGame.EnemyNumber;
            }
            return;
        }
        this.MapRect.Init(this.x, this.y, this.width, this.height);
        if (this.Type == 0 || this.Type == 2) {
            this.ProcessType0();
        }
        if (this.Type == 1) {
            this.ProcessType1();
        }
        if (this.Type == 3) {
            this.ProcessType3();
        }
        if (this.Type == 4) {
            this.ProcessType4();
        }
        this.Move();
    }

    public Object Clone() {
        Enemy ReturnObject = new Enemy();
        ReturnObject.width = this.width;
        ReturnObject.height = this.height;
        ReturnObject.Picture = new Animation[this.Picture.length];
        for (int i = 0; i < this.Picture.length; ++i) {
            ReturnObject.Picture[i] = this.Picture[i].Clone();
        }
        return ReturnObject;
    }

    private void ProcessType0() {
        this.State = this.State <= 2 ? 0 : 3;
        if (this.FireRounds > 0) {
            this.State = this.State == 0 ? 2 : 5;
            --this.FireRounds;
            if (this.EnemyBullet != null) {
                if (this.FireRounds == 7 && this.Type == 2) {
                    ActiveArea.Bullets.addElement(this.EnemyBullet);
                    PlatformGame.Vibrate(100);
                    int ymod = 1;
                    int xfrom = this.x + this.width;
                    if (Player.x < this.x) {
                        ymod = -1;
                        xfrom -= this.width;
                    }
                    this.EnemyBullet = new Bullet(2, xfrom, 12 + this.y, ymod, 0);
                }
                if (this.FireRounds == 0) {
                    ActiveArea.Bullets.addElement(this.EnemyBullet);
                    PlatformGame.Vibrate(100);
                    this.EnemyBullet = null;
                }
            }
            return;
        }
        if (--this.RoundsBeforeFire == 0) {
            this.RoundsBeforeFire = PlatformGame.Difficulty == 1 ? 8 : 16;
            if (this.x < ActiveArea.x + 176 && this.x + this.width > ActiveArea.x) {
                int FireY = this.y;
                FireY = this.Type == 0 ? (FireY += 3) : (FireY += 12);
                if (Player.y <= FireY && Player.y + 22 >= FireY) {
                    if (this.State == 0 && Player.x < this.x) {
                        this.FireRounds = 10;
                        this.EnemyBullet = new Bullet(2, this.x, FireY, -1, 0);
                    }
                    if (this.State == 3 && Player.x + 22 > this.x + this.width) {
                        this.FireRounds = 10;
                        this.EnemyBullet = new Bullet(2, this.x + this.width, FireY, 1, 0);
                    }
                }
            }
        }
    }

    private void ProcessType1() {
        if (this.FireRounds != 0) {
            if (--this.FireRounds == 0 && CollisionDetector.Check(this.MapRect, Player.PlayerRect)) {
                Player.WasHit();
            }
            return;
        }
        this.State = this.State <= 2 ? 1 : 4;
        if (Player.x > this.MovingPath[0] && Player.x < this.MovingPath[1] && Player.y < this.y + this.height && Player.y > this.y - this.height - 11) {
            if (CollisionDetector.Check(Player.PlayerRect, this.MapRect)) {
                if (this.State == 1) {
                    this.FireRounds = 9;
                    this.State = 2;
                    return;
                }
                if (this.State == 4) {
                    this.FireRounds = 9;
                    this.State = 5;
                    return;
                }
            }
            this.DoAttak();
        }
    }

    private void ProcessType3() {
        if (this.State == 0 || this.State == 3) {
            if (--this.FireRounds == 0) {
                this.State = this.State == 0 ? 1 : 4;
            }
            return;
        }
        if (this.State == 2 || this.State == 5) {
            if (CollisionDetector.Check(Player.PlayerRect, this.MapRect)) {
                Player.WasHit();
            }
            this.y += SPIDERJUMPARRAY[this.FireRounds - 1];
            if (--this.FireRounds == 0) {
                this.FireRounds = 18;
                this.State = 3;
                if (this.State == 2) {
                    this.State = 0;
                }
                return;
            }
            this.x = this.State == 2 ? (this.x -= 3) : (this.x += 3);
            return;
        }
        if (Player.x > this.MovingPath[0] && Player.x < this.MovingPath[1] && Player.y < this.y + this.height && Player.y > this.y - this.height - 11) {
            if (this.State == 1) {
                this.MapRect.left = this.x - 70;
                this.MapRect.right = this.x;
            }
            if (this.State == 4) {
                this.MapRect.left = this.x + this.Picture[4].width;
                this.MapRect.right = this.MapRect.left + 70;
            }
            if (CollisionDetector.Check(Player.PlayerRect, this.MapRect)) {
                if (this.State == 1) {
                    this.FireRounds = 18;
                    PlatformGame.Vibrate(100);
                    this.State = 2;
                    return;
                }
                if (this.State == 4) {
                    this.FireRounds = 18;
                    PlatformGame.Vibrate(100);
                    this.State = 5;
                    return;
                }
            }
            this.DoAttak();
        }
    }

    private void ProcessType4() {
        if (Player.x > this.MovingPath[0] && Player.x < this.MovingPath[1] && Player.y < this.y + this.height && Player.y > this.y - this.height - 11) {
            if (CollisionDetector.Check(Player.PlayerRect, this.MapRect)) {
                ActiveArea.BigBooms.addElement(new BigBoom(this.x + (this.width >> 1), this.y + (this.width >> 1)));
                --PlatformGame.EnemyNumber;
                this.State = 255;
                return;
            }
            this.DoAttak();
        }
    }

    private void Move() {
        if (this.MovingPath.length == 2) {
            if (this.State == 1 || this.State == 0) {
                this.State = 1;
                this.x -= 2;
                if (this.x < this.MovingPath[0]) {
                    this.State = 4;
                }
            } else if (this.State == 4 || this.State == 3) {
                this.State = 4;
                this.x += 2;
                if (this.x > this.MovingPath[1]) {
                    this.State = 1;
                }
            }
        }
    }

    private void DoAttak() {
        if (this.State == 1 && Player.x < this.x) {
            this.x = PlatformGame.Difficulty == 1 ? (this.x -= 2) : --this.x;
        }
        if (this.State == 4 && Player.x + 22 > this.x + this.width) {
            this.x = PlatformGame.Difficulty == 1 ? (this.x += 2) : ++this.x;
        }
    }
}

