/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class ImageLoader_PngInOne {
    public Image LastImage;
    private String ResourceFile;
    private String LastImageName = "";
    private ImageStruct[] Table;
    private byte[] isArray;
    private byte[] LastByteArray;
    private int BlockSize;
    private int BlockPos;
    private boolean isPreload;

    public ImageLoader_PngInOne(String ResourceFile) {
        this.InitTable(ResourceFile);
    }

    public Image createImage(String ImageFilename) {
        int OffsetNumber = -1;
        this.LastImageName = ImageFilename;
        for (int i = 0; i < this.Table.length; ++i) {
            if (!this.Table[i].Filename.equals(ImageFilename)) continue;
            OffsetNumber = i;
            break;
        }
        this.LastImage = null;
        this.LastByteArray = null;
        if (OffsetNumber == -1) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("There is no image with name '").append(ImageFilename).append("'"))));
            return null;
        }
        try {
            int size = this.Table[OffsetNumber].Len;
            this.LastByteArray = new byte[size];
            if (this.isPreload) {
                if (this.Table[OffsetNumber].Offset <= this.BlockPos || this.Table[OffsetNumber].Offset + size >= this.BlockPos + this.BlockSize) {
                    this.LoadBlock(this.Table[OffsetNumber].Offset);
                }
                System.arraycopy(this.isArray, this.Table[OffsetNumber].Offset - this.BlockPos, this.LastByteArray, 0, size);
            } else {
                InputStream is = this.getClass().getResourceAsStream(this.ResourceFile);
                if (is != null) {
                    is.skip(this.Table[OffsetNumber].Offset);
                    is.read(this.LastByteArray, 0, this.LastByteArray.length);
                    is.close();
                } else {
                    System.out.println(String.valueOf(String.valueOf(new StringBuffer("Resource file '").append(this.ResourceFile).append("' not found"))));
                }
            }
            this.LastImage = Image.createImage((byte[])this.LastByteArray, (int)0, (int)this.LastByteArray.length);
        }
        catch (Exception ex) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Exception during image load. Error message is '").append(ex).append("'. If you dont't know the error origin, please, contact developersupport@gamestry.com"))));
        }
        return this.LastImage;
    }

    public Image GetLastImage() {
        return this.LastImage;
    }

    private void InitTable(String ResourceFile) {
        block4: {
            this.ResourceFile = ResourceFile;
            try {
                DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream(ResourceFile));
                if (dis != null) {
                    int NumberOfSprites = dis.readShort();
                    this.Table = new ImageStruct[NumberOfSprites];
                    for (int i = 0; i < NumberOfSprites; ++i) {
                        byte[] temp = new byte[dis.readByte()];
                        dis.read(temp, 0, temp.length);
                        this.Table[i] = new ImageStruct();
                        this.Table[i].Filename = new String(temp);
                        this.Table[i].Offset = dis.readInt();
                        this.Table[i].Len = dis.readInt();
                    }
                    dis.close();
                    break block4;
                }
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Resource file '").append(ResourceFile).append("' not found"))));
            }
            catch (Exception ex) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Exception during resource file load. Error message is '").append(ex).append("'. If you dont't know the error origin, please, contact developersupport@gamestry.com"))));
            }
        }
    }

    public void Preload(int NumberOfBytes) {
        this.isPreload = true;
        this.BlockSize = NumberOfBytes;
        this.isArray = new byte[this.BlockSize];
        this.BlockPos = -NumberOfBytes;
    }

    private void LoadBlock(int from) {
        try {
            InputStream is = this.getClass().getResourceAsStream(this.ResourceFile);
            this.BlockPos = from;
            is.skip(from);
            int size = this.BlockSize;
            is.read(this.isArray);
            is.close();
        }
        catch (Exception ex) {
            System.out.println("Exception during file preload");
        }
    }
}

