/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class MapArray {
    public static int TileWidth;
    public static int TileHeight;
    public static int AreaTileX;
    public static int AreaTileY;
    public static int InnerX;
    public static int InnerY;
    public static Vector[][][] PrecalculatedArray;
    public static MapElement[] ResultElements;
    public static MapElement[] Background;
    public static Enemy[] ResultEnemy;
    public static Vector ResultBonus;
    public static int EnemyLng;
    public static int ElementLng;
    public static int BackLng;
    public static int Counter;

    public static void Init() {
        ResultElements = new MapElement[55];
        ResultEnemy = new Enemy[55];
        Background = new MapElement[55];
        TileWidth = ActiveArea.MapWidth / 176 + 1;
        TileHeight = ActiveArea.MapHeight / 176 + 1;
        PrecalculatedArray = new Vector[TileWidth][TileHeight][2];
        for (int i = 0; i < TileWidth; ++i) {
            for (int j = 0; j < TileHeight; ++j) {
                MapArray.PrecalculatedArray[i][j][0] = new Vector(0);
                MapArray.PrecalculatedArray[i][j][1] = new Vector(0);
            }
        }
        System.gc();
    }

    public static void Add(int x, int y, int width, int height, int type, Object Element) {
        Rect MapRect = new Rect(x, y, width, height);
        Rect TileRect = new Rect();
        for (int i = 0; i < TileWidth; ++i) {
            for (int j = 0; j < TileHeight; ++j) {
                TileRect.Init(i * 176, j * 208, 176, 208);
                if (!CollisionDetector.Check(TileRect, MapRect)) continue;
                PrecalculatedArray[i][j][type].addElement(Element);
            }
        }
    }

    public static void SetXY(int x, int y) {
        AreaTileX = x / 176;
        AreaTileY = y / 208;
        InnerX = x - AreaTileX * 176;
        InnerY = y - AreaTileY * 208;
        MapArray.FormatArrays();
    }

    public static void MoveLeft(int num) {
        if ((InnerX -= num) < 0) {
            InnerX += 176;
            --AreaTileX;
            MapArray.FormatArrays();
        }
    }

    public static void MoveRight(int num) {
        if ((InnerX += num) > 176) {
            InnerX -= 176;
            ++AreaTileX;
            MapArray.FormatArrays();
        }
    }

    public static void MoveUp(int num) {
        if ((InnerY -= num) < 0) {
            InnerY += 208;
            --AreaTileY;
            MapArray.FormatArrays();
        }
    }

    public static void MoveDown(int num) {
        if ((InnerY += num) > 208) {
            InnerY -= 208;
            ++AreaTileY;
            MapArray.FormatArrays();
        }
    }

    public static void FormatArrays() {
        BackLng = 0;
        EnemyLng = 0;
        ElementLng = 0;
        ++Counter;
        for (int x = 0; x < 2; ++x) {
            int thisX = AreaTileX + x;
            if (thisX >= TileWidth || thisX < 0) continue;
            Vector[][] tmpElX = PrecalculatedArray[thisX];
            for (int y = 0; y < 2; ++y) {
                int i;
                int thisY = AreaTileY + y;
                if (thisY >= TileHeight || thisY < 0) continue;
                Vector tmpEl = tmpElX[thisY][0];
                Vector tmpEn = tmpElX[thisY][1];
                for (i = 0; i < tmpEl.size(); ++i) {
                    MapElement tmptmpEl = (MapElement)tmpEl.elementAt(i);
                    if (tmptmpEl.Processed == Counter) continue;
                    if (tmptmpEl.Type == 2) {
                        MapArray.Background[MapArray.BackLng++] = tmptmpEl;
                    } else {
                        MapArray.ResultElements[MapArray.ElementLng++] = tmptmpEl;
                    }
                    tmptmpEl.Processed = Counter;
                }
                for (i = 0; i < tmpEn.size(); ++i) {
                    Enemy tmptmpEn = (Enemy)tmpEn.elementAt(i);
                    if (tmptmpEn.Processed == Counter) continue;
                    MapArray.ResultEnemy[MapArray.EnemyLng++] = tmptmpEn;
                    tmptmpEn.Processed = Counter;
                }
            }
        }
    }

    static {
        ResultBonus = new Vector(1);
    }
}

