/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Image;

public class MapLoader {
    public static Animation[] Animations;
    public static Image[] Sprites;
    public static int[] width;
    public static int[] height;
    public static int[] Index;
    public static String[] ImageFileNames;
    public static ImageLoader_PngInOne pIL;

    public static void SetProgress(int value) {
        PlatformGame.LoadingProgress = value;
        PlatformGame.pGameCanvas.repaint();
        PlatformGame.pGameCanvas.serviceRepaints();
    }

    public static int getIndex(String ImageFilename) {
        ImageFilename = ImageFilename.substring(0, ImageFilename.length() - 1);
        for (int i = 0; i < ImageFileNames.length; ++i) {
            if (ImageFileNames[i] == null || !ImageFileNames[i].equals(ImageFilename)) continue;
            MapLoader.ImageFileNames[i] = null;
            System.gc();
            return i;
        }
        return -1;
    }

    public static void LoadSprites() {
        try {
            DataInputStream LevelStream = new DataInputStream(PlatformGame.pPlatformGame.getClass().getResourceAsStream("/r/s"));
            int Number = LevelStream.readShort();
            Sprites = new Image[Number];
            width = new int[Number];
            height = new int[Number];
            Index = new int[Number];
            ImageFileNames = new String[Number];
            System.gc();
            pIL = new ImageLoader_PngInOne("/r/res");
            pIL.Preload(128000);
            for (int i = 0; i < Number; ++i) {
                String str = MapLoader.LoadString(LevelStream);
                if (!str.endsWith("r")) {
                    MapLoader.Sprites[i] = pIL.createImage(str);
                    MapLoader.width[i] = Sprites[i].getWidth();
                    MapLoader.height[i] = Sprites[i].getHeight();
                    MapLoader.Index[i] = i;
                    if (i > 31 && i < 146) {
                        MapLoader.ImageFileNames[i] = str;
                    }
                } else {
                    MapLoader.Index[i] = i > 105 && i < 110 ? i + 4 : (i == 74 ? 75 : MapLoader.getIndex(str));
                }
                MapLoader.SetProgress(75 * i / Number);
            }
            pIL = null;
            ImageFileNames = null;
            System.gc();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MapLoader(int Level2) {
        DataInputStream LevelStream = new DataInputStream(this.getClass().getResourceAsStream("/Levels/".concat(String.valueOf(String.valueOf(Level2)))));
        try {
            int i;
            ActiveArea.MapName = MapLoader.LoadString(LevelStream);
            PlatformGame.pGameCanvas.repaint();
            PlatformGame.pGameCanvas.serviceRepaints();
            ActiveArea.MapWidth = LevelStream.readInt();
            ActiveArea.MapHeight = LevelStream.readInt();
            MapArray.Init();
            int Number = LevelStream.readShort();
            Animations = new Animation[Number];
            for (i = 0; i < Number; ++i) {
                byte Delay = LevelStream.readByte();
                MapLoader.Animations[i] = new Animation(LevelStream.readByte());
                for (int sp = 0; sp < MapLoader.Animations[i].count_frame; ++sp) {
                    try {
                        short point = LevelStream.readShort();
                        MapLoader.Animations[i].Sprites[sp] = Sprites[Index[point]];
                        MapLoader.Animations[i].width = width[Index[point]];
                        MapLoader.Animations[i].height = height[Index[point]];
                        Animation.i = i;
                        if (Index[point] == point) continue;
                        MapLoader.Animations[i].need_invert = true;
                        continue;
                    }
                    catch (Exception point) {
                        // empty catch block
                    }
                }
                MapLoader.Animations[i].delay = Delay;
            }
            Number = LevelStream.readShort();
            System.gc();
            PlatformGame.CollectWeapon = 0;
            PlatformGame.CollectMedic = 0;
            PlatformGame.TotalWeapon = 0;
            PlatformGame.TotalMedic = 0;
            for (i = 0; i < Number; ++i) {
                MapElement pPl = new MapElement();
                pPl.Type = LevelStream.readByte();
                if (pPl.Type == 4) {
                    ++PlatformGame.TotalWeapon;
                }
                if (pPl.Type == 5) {
                    ++PlatformGame.TotalMedic;
                }
                if (pPl.Type == 5 && PlatformGame.Difficulty == 2) {
                    pPl.Type = 3;
                }
                pPl.Picture = Animations[LevelStream.readShort()].Clone();
                pPl.x = LevelStream.readInt();
                pPl.y = LevelStream.readInt();
                pPl.width = LevelStream.readShort();
                pPl.height = LevelStream.readShort();
                MapArray.Add(pPl.x, pPl.y, pPl.width, pPl.height, 0, pPl);
                pPl.tilewidth = pPl.width / pPl.Picture.width;
                pPl.tileheight = pPl.height / pPl.Picture.height;
                pPl.MapRect = new Rect(pPl.x, pPl.y, pPl.width, pPl.height);
                if (pPl.Type != 6 && pPl.Type != 7) continue;
                pPl.MovingPath = new int[2];
                if (pPl.Type == 6) {
                    pPl.MovingPath[0] = pPl.y;
                    pPl.MovingPath[1] = pPl.y + pPl.height - pPl.Picture.height;
                    pPl.height = pPl.Picture.height;
                    continue;
                }
                pPl.MovingPath[0] = pPl.x;
                pPl.MovingPath[1] = pPl.x + pPl.width - pPl.Picture.width;
                pPl.width = pPl.Picture.width;
            }
            LevelStream.readByte();
            Player.x = LevelStream.readInt();
            Player.y = LevelStream.readInt();
            Player.Picture = new Animation[LevelStream.readByte()];
            for (i = 0; i < Player.Picture.length; ++i) {
                Player.Picture[i] = Animations[LevelStream.readShort()].Clone();
            }
            System.gc();
            ActiveArea.SetScreenPositionByPlayer();
            Number = LevelStream.readByte();
            if (Number > 0) {
                Enemy[] StandartEnemys = new Enemy[Number];
                for (i = 0; i < Number; ++i) {
                    StandartEnemys[i] = new Enemy();
                    StandartEnemys[i].Picture = new Animation[LevelStream.readByte()];
                    for (int j = 0; j < StandartEnemys[i].Picture.length; ++j) {
                        short AniNum = LevelStream.readShort();
                        StandartEnemys[i].Picture[j] = Animations[AniNum].Clone();
                        StandartEnemys[i].width = MapLoader.Animations[AniNum].width;
                        StandartEnemys[i].height = MapLoader.Animations[AniNum].height;
                    }
                }
                System.gc();
                PlatformGame.EnemyNumber = LevelStream.readByte();
                for (i = 0; i < PlatformGame.EnemyNumber; ++i) {
                    byte counter = LevelStream.readByte();
                    Enemy pEnemy = (Enemy)StandartEnemys[counter].Clone();
                    pEnemy.Type = LevelStream.readByte();
                    pEnemy.Energy = 1;
                    if (pEnemy.Type == 2) {
                        pEnemy.Energy = 2;
                    }
                    pEnemy.x = LevelStream.readInt();
                    pEnemy.y = LevelStream.readInt();
                    pEnemy.MovingPath = new int[LevelStream.readByte()];
                    for (int j = 0; j < pEnemy.MovingPath.length; ++j) {
                        pEnemy.MovingPath[j] = LevelStream.readInt();
                    }
                    if (pEnemy.MovingPath.length == 1) {
                        MapArray.Add(pEnemy.MovingPath[0], pEnemy.y, pEnemy.width, pEnemy.height, 1, pEnemy);
                        if (pEnemy.x < pEnemy.MovingPath[0]) {
                            pEnemy.State = 3;
                        }
                        pEnemy.x = pEnemy.MovingPath[0];
                        continue;
                    }
                    MapArray.Add(pEnemy.MovingPath[0], pEnemy.y, pEnemy.MovingPath[1] - pEnemy.MovingPath[0] + pEnemy.width, pEnemy.height, 1, pEnemy);
                }
                StandartEnemys = null;
                System.gc();
            }
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        System.gc();
        PlatformGame.Bullet = Animations[2];
        PlatformGame.Granade = Animations[7];
        PlatformGame.GranadeBullet = Animations[5];
        PlatformGame.BoomAnimation = Animations[1];
        FrashMeet.Picture = Animations[0];
        PlatformGame.BulletIcon = Animations[4];
        PlatformGame.GranadeIcon = Animations[3];
        PlatformGame.LifeIcon = Animations[6];
        PlatformGame.BoxBoom = Animations[10];
        PlatformGame.LifeIconBonus = new Bonus();
        PlatformGame.LifeIconBonus.Picture = Animations[11];
        PlatformGame.LifeIconBonus.Type = 0;
        PlatformGame.GranadeBonus = new Bonus();
        PlatformGame.GranadeBonus.Picture = PlatformGame.Granade;
        PlatformGame.GranadeBonus.Type = 1;
        Animations = null;
    }

    public static final String LoadString(DataInputStream is) throws Exception {
        byte[] temp = new byte[is.readByte()];
        is.read(temp, 0, temp.length);
        return new String(temp);
    }
}

