/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.FullCanvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public abstract class TXCanvas
extends FullCanvas {
    private long globalAmount = 100L;
    private long globalCount = 1L;
    private long lastTime = 0L;
    private int waitState = 1;
    private boolean exitThread = false;
    private int exitCode = -1;
    public String[] buttons;
    protected boolean needAll;

    protected abstract void onInit();

    protected abstract void onDone();

    protected abstract void onPaint(Graphics var1);

    protected abstract void onTick(long var1);

    protected abstract void onStart();

    private final void updateTime() {
        this.lastTime = System.currentTimeMillis() - this.globalAmount / this.globalCount;
    }

    protected final void paint(Graphics graphics) {
        this.onPaint(graphics);
        this.drawButtons(graphics);
    }

    protected final void drawButtons(Graphics graphics) {
        graphics.setFont(Font.getFont((int)32, (int)0, (int)0));
        graphics.setClip(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(255, 255, 0);
        if (this.buttons != null) {
            int n = 0;
            while (n < this.buttons.length) {
                if (n == 0) {
                    graphics.drawString(this.buttons[n], 0, this.getHeight(), 4 | 0x20);
                } else {
                    graphics.drawString(this.buttons[n], this.getWidth(), this.getHeight(), 8 | 0x20);
                }
                ++n;
            }
        }
    }

    private final synchronized void notifyEx() {
        ((Object)((Object)this)).notify();
    }

    private final synchronized void waitEx() throws InterruptedException {
        ((Object)((Object)this)).wait();
    }

    protected void showNotify() {
        this.notifyEx();
        this.needAll = true;
    }

    protected void hideNotify() {
    }

    public final int run() {
        try {
            TripleX tripleX;
            this.exitCode = -1;
            if (Display.getDisplay((MIDlet)TripleX.getInstance()).getCurrent() != this) {
                this.waitEx();
            }
            this.updateTime();
            while ((tripleX = TripleX.getInstance()) != null) {
                long l = System.currentTimeMillis();
                long l2 = l - this.lastTime;
                this.lastTime = l;
                this.globalAmount += l2;
                ++this.globalCount;
                if (l2 < 80L) {
                    Thread.sleep(80L - l2);
                    l2 = 80L;
                }
                this.waitState = 1;
                this.onTick(l2);
                if (this.exitThread) break;
                if (this.waitState != 1) {
                    this.serviceRepaints();
                    continue;
                }
                this.waitState = 2;
            }
            this.onDone();
        }
        catch (InterruptedException interruptedException) {
            this.onDone();
            TripleX.getInstance().quit();
            return -1;
        }
        return this.exitCode;
    }

    public final int start() {
        this.onStart();
        this.onInit();
        this.exitThread = false;
        Display display = Display.getDisplay((MIDlet)TripleX.getInstance());
        if (display.getCurrent() != this) {
            display.setCurrent((Displayable)this);
        }
        while (display.getCurrent() != this) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.run();
        return this.exitCode;
    }

    public final void step() {
        boolean bl;
        boolean bl2 = bl = this.waitState == 2;
        if (bl) {
            this.updateTime();
        }
        this.waitState = 0;
        if (bl) {
            this.notifyEx();
        }
    }

    protected void exit(int n) {
        this.exitThread = true;
        this.exitCode = n;
    }
}

